/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.impl;

import com.atlassian.confluence.plugins.createcontent.AbstractPluginSettingsBlueprintStateController;
import com.atlassian.confluence.plugins.createcontent.api.exceptions.BlueprintIllegalArgumentException;
import com.atlassian.confluence.plugins.createcontent.api.exceptions.ResourceErrorType;
import com.atlassian.confluence.plugins.createcontent.services.PromotedTemplateService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DefaultPromotedTemplateService
implements PromotedTemplateService {
    public static final String KEY_PROMOTED_TEMPLATES = "promotedTemplates";
    private final SpaceManager spaceManager;
    private final PermissionManager permissionManager;
    private final PluginSettingsFactory pluginSettingsFactory;

    @Autowired
    public DefaultPromotedTemplateService(@ComponentImport SpaceManager spaceManager, @ComponentImport PermissionManager permissionManager, @ComponentImport @Qualifier(value="extendedPluginSettingsFactory") PluginSettingsFactory pluginSettingsFactory) {
        this.spaceManager = spaceManager;
        this.permissionManager = permissionManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    @Override
    public void promoteTemplate(long templateId, @Nonnull String spaceKey) throws BlueprintIllegalArgumentException {
        this.toggleTemplatePromotion(templateId, spaceKey, true);
    }

    @Override
    public void demoteTemplate(long templateId, @Nonnull String spaceKey) throws BlueprintIllegalArgumentException {
        this.toggleTemplatePromotion(templateId, spaceKey, false);
    }

    public List<Long> getPromotedTemplates(@Nonnull Space space) {
        List promotedTemplateIds = (List)this.pluginSettingsFactory.createSettingsForKey(AbstractPluginSettingsBlueprintStateController.getModuleNamespace(space)).get(KEY_PROMOTED_TEMPLATES);
        return promotedTemplateIds != null ? promotedTemplateIds.stream().map(Long::valueOf).toList() : new ArrayList<Long>();
    }

    private void toggleTemplatePromotion(long templateId, @Nonnull String spaceKey, boolean promote) throws BlueprintIllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)spaceKey)) {
            throw new BlueprintIllegalArgumentException("Space key is required to promote/demote template with id: " + templateId, ResourceErrorType.PARAMETER_MISSING, (Object)"spaceKey");
        }
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            throw new BlueprintIllegalArgumentException("Space with key '" + spaceKey + "' could not be found.", ResourceErrorType.NOT_FOUND_SPACE, (Object)spaceKey);
        }
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.ADMINISTER, (Object)space)) {
            throw new BlueprintIllegalArgumentException("Only space administrators can enable / disable plugin modules per space", ResourceErrorType.PERMISSION_USER_ADMIN_SPACE, (Object)spaceKey);
        }
        PluginSettings settings = this.pluginSettingsFactory.createSettingsForKey(AbstractPluginSettingsBlueprintStateController.getModuleNamespace(space));
        List ids = (List)settings.get(KEY_PROMOTED_TEMPLATES);
        HashSet<String> promotedTemplatesIds = new HashSet<String>();
        if (ids != null) {
            promotedTemplatesIds.addAll(ids);
        }
        if (promote) {
            promotedTemplatesIds.add(String.valueOf(templateId));
        } else {
            promotedTemplatesIds.remove(String.valueOf(templateId));
        }
        settings.put(KEY_PROMOTED_TEMPLATES, new ArrayList(promotedTemplatesIds));
    }
}

