/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.impl;

import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.plugins.createcontent.services.UserStorageService;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.user.User;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DefaultUserStorageService
implements UserStorageService {
    private final PluginSettings pluginSettings;
    private static final String PLUGIN_SETTINGS_CONTEXT = DefaultUserStorageService.class.getName();
    private final String SEPARATE_CHARACTER = ",";
    private final List<String> KEY_ACCEPTED = Collections.singletonList("quick-create");

    @Autowired
    public DefaultUserStorageService(@ComponentImport @Qualifier(value="extendedPluginSettingsFactory") PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey(PLUGIN_SETTINGS_CONTEXT);
    }

    @Override
    public boolean isKeyStoredForCurrentUser(String key) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null || StringUtils.isEmpty((CharSequence)key) || !this.KEY_ACCEPTED.contains(key)) {
            return false;
        }
        Object users = this.pluginSettings.get(key);
        return users != null && users.toString().contains(user.getName() + ",");
    }

    @Override
    public void storeKeyForCurrentUser(String key) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null || user.getName() == null || StringUtils.isEmpty((CharSequence)key) || !this.KEY_ACCEPTED.contains(key)) {
            throw new BadRequestException(Response.Status.BAD_REQUEST.getReasonPhrase());
        }
        Object users = this.pluginSettings.get(key);
        if (users == null || !users.toString().contains(user.getName() + ",")) {
            this.pluginSettings.put(key, (Object)(String.valueOf(users == null ? "" : users) + user.getName() + ","));
        }
    }

    @Override
    public void removeKeyForUser(String key, User user) {
        if (key == null || !this.KEY_ACCEPTED.contains(key)) {
            throw new UnsupportedOperationException("The key supplied is not valid.");
        }
        if (user != null && user.getName() != null && !user.getName().isEmpty()) {
            Object pluginSettingsRecord = this.pluginSettings.get(key);
            if (pluginSettingsRecord == null) {
                return;
            }
            String tokenToRemove = user.getName() + ",";
            String userlistString = pluginSettingsRecord.toString();
            if (userlistString.contains(tokenToRemove)) {
                String amendedUserList = userlistString.replaceFirst(Matcher.quoteReplacement(tokenToRemove), "");
                if (!amendedUserList.isEmpty()) {
                    this.pluginSettings.put(key, (Object)amendedUserList);
                } else {
                    this.pluginSettings.remove(key);
                }
            }
        } else {
            throw new UnsupportedOperationException("The user supplied is not valid.");
        }
    }
}

