/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.listeners;

import com.atlassian.confluence.api.service.settings.ExtendedPluginSettings;
import com.atlassian.confluence.api.service.settings.ExtendedPluginSettingsFactory;
import com.atlassian.confluence.event.events.space.SpaceRemoveEvent;
import com.atlassian.confluence.plugins.createcontent.AbstractPluginSettingsBlueprintStateController;
import com.atlassian.confluence.plugins.createcontent.api.services.ContentBlueprintService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RemoveSpaceListener {
    private final ExtendedPluginSettingsFactory pluginSettingsFactory;
    private final EventPublisher eventPublisher;
    private final ContentBlueprintService contentBlueprintService;

    @Autowired
    public RemoveSpaceListener(@ComponentImport ExtendedPluginSettingsFactory pluginSettingsFactory, @ComponentImport EventPublisher eventPublisher, ContentBlueprintService contentBlueprintService) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.eventPublisher = eventPublisher;
        this.contentBlueprintService = contentBlueprintService;
    }

    @EventListener
    public void onSpaceRemoveEvent(SpaceRemoveEvent event) {
        Space deletedSpace = event.getSpace();
        ExtendedPluginSettings pluginSettings = this.pluginSettingsFactory.createSettingsForKey(AbstractPluginSettingsBlueprintStateController.getModuleNamespace(deletedSpace));
        for (String key : pluginSettings.getKeys()) {
            pluginSettings.remove(key);
        }
        this.contentBlueprintService.deleteContentBlueprintsForSpace(deletedSpace.getKey());
    }

    @PreDestroy
    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @PostConstruct
    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }
}

