/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.plugins.createcontent.ContentBlueprintCleaner;
import com.atlassian.confluence.plugins.createcontent.ContentBlueprintManager;
import com.atlassian.confluence.plugins.createcontent.ContentTemplateRefManager;
import com.atlassian.confluence.plugins.createcontent.SpaceBlueprintManager;
import com.atlassian.confluence.plugins.createcontent.extensions.BlueprintModuleDescriptor;
import com.atlassian.confluence.plugins.createcontent.rest.AbstractRestResource;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.List;

@Path(value="/admin")
public class BlueprintsAdminResource
extends AbstractRestResource {
    private final SpaceBlueprintManager spaceBlueprintManager;
    private final ContentBlueprintManager contentBlueprintManager;
    private final ContentTemplateRefManager contentTemplateManager;
    private final PluginAccessor pluginAccessor;
    private final ContentBlueprintCleaner contentBlueprintCleaner;

    @Inject
    public BlueprintsAdminResource(@Named(value="spaceBlueprintManager") SpaceBlueprintManager spaceBlueprintManager, ContentBlueprintManager contentBlueprintManager, ContentTemplateRefManager contentTemplateManager, @ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport AccessModeService accessModeService, ContentBlueprintCleaner contentBlueprintCleaner) {
        super(permissionManager, spaceManager, accessModeService);
        this.spaceBlueprintManager = spaceBlueprintManager;
        this.contentBlueprintManager = contentBlueprintManager;
        this.contentTemplateManager = contentTemplateManager;
        this.pluginAccessor = pluginAccessor;
        this.contentBlueprintCleaner = contentBlueprintCleaner;
    }

    @POST
    @ReadOnlyAccessAllowed
    @Path(value="refreshAoTables")
    @Consumes(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public int refreshAoTables() {
        this.checkAdminPermission();
        this.spaceBlueprintManager.deleteAll();
        this.contentBlueprintManager.deleteAll();
        this.contentTemplateManager.deleteAll();
        int refreshed = this.refreshContentBlueprints();
        return refreshed += this.spaceBlueprintManager.getAll().size();
    }

    @DELETE
    @ReadOnlyAccessAllowed
    @Path(value="cleanup")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response cleanUp() {
        this.checkAdminPermission();
        int totalSpaces = this.contentBlueprintCleaner.cleanUp();
        return totalSpaces > -1 ? Response.ok().entity((Object)totalSpaces).build() : Response.serverError().build();
    }

    private int refreshContentBlueprints() {
        List moduleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(BlueprintModuleDescriptor.class);
        for (BlueprintModuleDescriptor moduleDescriptor : moduleDescriptors) {
            this.contentBlueprintManager.getPluginBackedContentBlueprint(moduleDescriptor.getBlueprintKey(), null);
        }
        return moduleDescriptors.size();
    }
}

