/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.dmz.security.delegate.ScopesRequestCacheDelegate;
import com.atlassian.confluence.plugins.createcontent.api.exceptions.BlueprintIllegalArgumentException;
import com.atlassian.confluence.plugins.createcontent.api.services.ContentBlueprintService;
import com.atlassian.confluence.plugins.createcontent.extensions.UserBlueprintConfigManager;
import com.atlassian.confluence.plugins.createcontent.rest.AbstractRestResource;
import com.atlassian.confluence.plugins.createcontent.rest.entities.BlueprintDraftEntity;
import com.atlassian.confluence.plugins.createcontent.rest.entities.CreateBlueprintPageRestEntity;
import com.atlassian.confluence.plugins.createcontent.rest.entities.PageEntity;
import com.atlassian.confluence.plugins.createcontent.services.model.BlueprintPage;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.struts.flash.FlashScope;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.struts.xsrf.XsrfTokenGenerator;
import com.atlassian.user.User;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.UUID;

@Path(value="/content-blueprint")
public class ContentBlueprintResource
extends AbstractRestResource {
    private final ContentBlueprintService contentBlueprintService;
    private final GlobalSettingsManager settingsManager;
    private final UserBlueprintConfigManager userBlueprintConfigManager;
    private final XsrfTokenGenerator simpleXsrfTokenGenerator;
    private final HttpContext httpContext;
    private final UserAccessor userAccessor;

    @Inject
    public ContentBlueprintResource(@ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager, ContentBlueprintService legacyContentBlueprintService, @ComponentImport GlobalSettingsManager settingsManager, UserBlueprintConfigManager userBlueprintConfigManager, @ComponentImport AccessModeService accessModeService, @ComponentImport XsrfTokenGenerator simpleXsrfTokenGenerator, @ComponentImport HttpContext httpContext, @ComponentImport UserAccessor userAccessor, @ComponentImport ScopesRequestCacheDelegate scopesRequestCacheDelegate) {
        super(permissionManager, spaceManager, accessModeService);
        this.contentBlueprintService = legacyContentBlueprintService;
        this.settingsManager = settingsManager;
        this.userBlueprintConfigManager = userBlueprintConfigManager;
        this.simpleXsrfTokenGenerator = simpleXsrfTokenGenerator;
        this.httpContext = httpContext;
        this.userAccessor = userAccessor;
        this.setScopesRequestCacheDelegate(scopesRequestCacheDelegate);
    }

    @POST
    @Path(value="create-content")
    @AnonymousSiteAccess
    @Consumes(value={"application/json", "application/xml"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public PageEntity createPage(CreateBlueprintPageRestEntity entity) throws BlueprintIllegalArgumentException {
        this.checkNullEntity(entity);
        ConfluenceUser user = this.getUser();
        boolean firstBlueprintCreation = false;
        if (user != null) {
            firstBlueprintCreation = entity.getContentBlueprintId() != null && this.userBlueprintConfigManager.isFirstBlueprintOfTypeForUser(UUID.fromString(entity.getContentBlueprintId()), user);
        }
        BlueprintPage page = this.contentBlueprintService.createPage(entity, user);
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        PageEntity result = new PageEntity(page, baseUrl);
        if (firstBlueprintCreation) {
            this.enableFirstBlueprintCreationFlashScope(result);
        }
        return result;
    }

    @POST
    @Path(value="create-draft")
    @AnonymousSiteAccess
    @Consumes(value={"application/json", "application/xml"})
    @ScopesAllowed(requiredScope={"JSM_KB", "READ"})
    public BlueprintDraftEntity createDraft(CreateBlueprintPageRestEntity entity, @QueryParam(value="xoauth_requestor_id") String username) throws BlueprintIllegalArgumentException {
        if (this.hasPermittedOAuthScope("JSM_KB") && username != null) {
            AuthenticatedUserThreadLocal.setUser((User)this.userAccessor.getUser(username));
        }
        this.checkNullEntity(entity);
        ContentEntityObject contentDraft = this.contentBlueprintService.createContentDraft(entity, this.getUser());
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        return new BlueprintDraftEntity(contentDraft, baseUrl, this.getAtlToken());
    }

    private void enableFirstBlueprintCreationFlashScope(PageEntity result) {
        String flashId = FlashScope.persist();
        result.setCreateSuccessRedirectUrl(FlashScope.getFlashScopeUrl((String)result.getUrl(), (String)flashId));
        if (result.getIndexPage() != null) {
            result.getIndexPage().setCreateSuccessRedirectUrl(FlashScope.getFlashScopeUrl((String)result.getIndexPage().getUrl(), (String)flashId));
        }
    }

    private String getAtlToken() {
        return this.simpleXsrfTokenGenerator.getToken(this.httpContext.getActiveRequest(), true);
    }
}

