/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.rest;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.plugins.createcontent.ContentTemplateRefManager;
import com.atlassian.confluence.plugins.createcontent.activeobjects.ContentTemplateRefAo;
import com.atlassian.confluence.plugins.createcontent.api.exceptions.ResourceErrorType;
import com.atlassian.confluence.plugins.createcontent.exceptions.ResourceException;
import com.atlassian.confluence.plugins.createcontent.impl.ContentTemplateRef;
import com.atlassian.confluence.plugins.createcontent.rest.AbstractRestResource;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import java.util.UUID;

@Path(value="/templatesRefs")
public class ContentTemplateRefResource
extends AbstractRestResource {
    public static final String PARAM_ID = "id";
    private final ContentTemplateRefManager contentTemplateRefManager;
    private final ActiveObjects activeObjects;
    private final UserManager userManager;

    @Inject
    public ContentTemplateRefResource(@ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager, ContentTemplateRefManager contentTemplateRefManager, ActiveObjects activeObjects, @ComponentImport AccessModeService accessModeService, @ComponentImport UserManager userManager) {
        super(permissionManager, spaceManager, accessModeService);
        this.contentTemplateRefManager = contentTemplateRefManager;
        this.activeObjects = activeObjects;
        this.userManager = userManager;
    }

    @AdminOnly
    @DELETE
    @ReadOnlyAccessAllowed
    @Path(value="deleteAll")
    public Integer deleteAll() {
        this.checkAdminPermission();
        return this.contentTemplateRefManager.deleteAll();
    }

    @AnonymousSiteAccess
    @GET
    @Path(value="{id}")
    @ScopesAllowed(requiredScope={"READ"})
    public ContentTemplateRef get(@PathParam(value="id") UUID uuid) {
        this.forbidUnlicensedUsers();
        this.checkNullParameter(uuid, PARAM_ID);
        return (ContentTemplateRef)this.contentTemplateRefManager.getById(uuid);
    }

    @AdminOnly
    @DELETE
    @Path(value="{id}")
    public boolean delete(@PathParam(value="id") UUID uuid) {
        this.checkNullParameter(uuid, PARAM_ID);
        return this.contentTemplateRefManager.delete(uuid);
    }

    @AdminOnly
    @POST
    @Consumes(value={"application/json", "application/xml"})
    public UUID create(ContentTemplateRef contentTemplateRef) {
        this.checkNullEntity(contentTemplateRef);
        ContentTemplateRefAo ao = (ContentTemplateRefAo)this.activeObjects.executeInTransaction(() -> this.saveContentTemplateRef(contentTemplateRef));
        if (ao != null) {
            return UUID.fromString(ao.getUuid());
        }
        return null;
    }

    @AdminOnly
    @PUT
    @Consumes(value={"application/json", "application/xml"})
    public void update(ContentTemplateRef contentTemplateRef) {
        this.contentTemplateRefManager.update(contentTemplateRef);
        for (ContentTemplateRef child : contentTemplateRef.getChildren()) {
            this.update(child);
        }
    }

    @Nonnull
    private ContentTemplateRefAo saveContentTemplateRef(@Nonnull ContentTemplateRef contentTemplateRef) {
        ContentTemplateRefAo parentAo = (ContentTemplateRefAo)this.contentTemplateRefManager.createAo(contentTemplateRef);
        for (ContentTemplateRef child : contentTemplateRef.getChildren()) {
            ContentTemplateRefAo childAo = this.saveContentTemplateRef(child);
            childAo.setParent(parentAo);
            childAo.save();
        }
        return parentAo;
    }

    private void forbidUnlicensedUsers() {
        UserKey userKey = this.userManager.getRemoteUserKey();
        if (userKey != null && !this.userManager.isLicensed(userKey)) {
            throw new ResourceException("Only licensed user can make this request.", Response.Status.BAD_REQUEST, ResourceErrorType.PERMISSION_USER_CREATE);
        }
    }
}

