/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.plugins.createcontent.api.exceptions.BlueprintIllegalArgumentException;
import com.atlassian.confluence.plugins.createcontent.rest.AbstractRestResource;
import com.atlassian.confluence.plugins.createcontent.services.PromotedBlueprintService;
import com.atlassian.confluence.plugins.createcontent.services.PromotedTemplateService;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.inject.Inject;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;

@Path(value="/promotion")
public class PromotedEntityResource
extends AbstractRestResource {
    public static final String PARAM_BLUEPRINT_ID = "blueprintId";
    public static final String PARAM_SPACE_KEY = "spaceKey";
    public static final String PARAM_ID = "id";
    private final PromotedBlueprintService promotedBlueprintService;
    private final PromotedTemplateService promotedTemplateService;

    @Inject
    public PromotedEntityResource(PromotedBlueprintService promotedBlueprintService, PromotedTemplateService promotedTemplateService, @ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager, @ComponentImport AccessModeService accessModeService) {
        super(permissionManager, spaceManager, accessModeService);
        this.promotedBlueprintService = promotedBlueprintService;
        this.promotedTemplateService = promotedTemplateService;
    }

    @Path(value="promote-blueprint/{blueprintId}")
    @PUT
    @ScopesAllowed(requiredScope={"WRITE"})
    public boolean promoteBlueprint(@PathParam(value="blueprintId") String blueprintId, @QueryParam(value="spaceKey") String spaceKey) throws BlueprintIllegalArgumentException {
        return this.promotedBlueprintService.promoteBlueprint(blueprintId, spaceKey);
    }

    @Path(value="promote-blueprint/{blueprintId}")
    @DELETE
    @ScopesAllowed(requiredScope={"WRITE"})
    public boolean demoteBlueprint(@PathParam(value="blueprintId") String blueprintId, @QueryParam(value="spaceKey") String spaceKey) throws BlueprintIllegalArgumentException {
        return this.promotedBlueprintService.demoteBlueprint(blueprintId, spaceKey);
    }

    @Path(value="promote-template/{id}")
    @PUT
    @ScopesAllowed(requiredScope={"WRITE"})
    public void promoteTemplate(@PathParam(value="id") long templateId, @QueryParam(value="spaceKey") String spaceKey) throws BlueprintIllegalArgumentException {
        this.promotedTemplateService.promoteTemplate(templateId, spaceKey);
    }

    @Path(value="promote-template/{id}")
    @DELETE
    @ScopesAllowed(requiredScope={"WRITE"})
    public void demoteTemplate(@PathParam(value="id") long templateId, @QueryParam(value="spaceKey") String spaceKey) throws BlueprintIllegalArgumentException {
        this.promotedTemplateService.demoteTemplate(templateId, spaceKey);
    }

    @Path(value="promote-template/")
    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Collection<Long> getPromotedTemplates(@QueryParam(value="spaceKey") String spaceKey) {
        this.checkEmptyParameter(spaceKey, PARAM_SPACE_KEY);
        Space space = this.getAndCheckSpace(spaceKey);
        return this.promotedTemplateService.getPromotedTemplates(space);
    }
}

