/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.rest;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.dmz.security.delegate.ScopesRequestCacheDelegate;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.plugins.createcontent.ContentTemplateRefManager;
import com.atlassian.confluence.plugins.createcontent.SpaceBlueprintManager;
import com.atlassian.confluence.plugins.createcontent.activeobjects.ContentTemplateRefAo;
import com.atlassian.confluence.plugins.createcontent.activeobjects.UuidBackedAo;
import com.atlassian.confluence.plugins.createcontent.api.exceptions.BlueprintIllegalArgumentException;
import com.atlassian.confluence.plugins.createcontent.api.exceptions.ResourceErrorType;
import com.atlassian.confluence.plugins.createcontent.api.services.SpaceBlueprintService;
import com.atlassian.confluence.plugins.createcontent.exceptions.ResourceException;
import com.atlassian.confluence.plugins.createcontent.impl.ContentTemplateRef;
import com.atlassian.confluence.plugins.createcontent.impl.SpaceBlueprint;
import com.atlassian.confluence.plugins.createcontent.rest.AbstractRestResource;
import com.atlassian.confluence.plugins.createcontent.rest.SpaceBlueprintEntity;
import com.atlassian.confluence.plugins.createcontent.rest.entities.BlueprintSpaceEntity;
import com.atlassian.confluence.plugins.createcontent.rest.entities.CreateBlueprintSpaceRestEntity;
import com.atlassian.confluence.plugins.createcontent.rest.entities.CreatePersonalSpaceRestEntity;
import com.atlassian.confluence.plugins.createcontent.services.model.BlueprintSpace;
import com.atlassian.confluence.plugins.createcontent.template.PluginPageTemplateHelper;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@Path(value="/space-blueprint")
public class SpaceBlueprintResource
extends AbstractRestResource {
    public static final String PARAM_KEY = "key";
    public static final String PARAM_ID = "id";
    private final SpaceBlueprintService spaceBlueprintService;
    private final SpaceBlueprintManager spaceBlueprintManager;
    private final ContentTemplateRefManager contentTemplateRefManager;
    private final PluginPageTemplateHelper pageTemplateHelper;
    private final PageTemplateManager pageTemplateManager;
    private final ActiveObjects activeObjects;
    private final GlobalSettingsManager settingsManager;
    private final UserAccessor userAccessor;

    @Inject
    public SpaceBlueprintResource(SpaceBlueprintService spaceBlueprintService, @ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager, @Named(value="spaceBlueprintManager") SpaceBlueprintManager spaceBlueprintManager, ContentTemplateRefManager contentTemplateRefManager, PluginPageTemplateHelper pageTemplateHelper, @ComponentImport PageTemplateManager pageTemplateManager, ActiveObjects activeObjects, @ComponentImport GlobalSettingsManager settingsManager, @ComponentImport AccessModeService accessModeService, @ComponentImport ScopesRequestCacheDelegate scopesRequestCacheDelegate, @ComponentImport UserAccessor userAccessor) {
        super(permissionManager, spaceManager, accessModeService);
        this.spaceBlueprintService = spaceBlueprintService;
        this.spaceBlueprintManager = spaceBlueprintManager;
        this.contentTemplateRefManager = contentTemplateRefManager;
        this.pageTemplateHelper = pageTemplateHelper;
        this.pageTemplateManager = pageTemplateManager;
        this.activeObjects = activeObjects;
        this.settingsManager = settingsManager;
        this.userAccessor = userAccessor;
        this.setScopesRequestCacheDelegate(scopesRequestCacheDelegate);
    }

    @POST
    @Path(value="create-space")
    @Consumes(value={"application/json", "application/xml"})
    @ScopesAllowed(requiredScope={"JSM_KB", "WRITE"})
    public BlueprintSpaceEntity createSpace(CreateBlueprintSpaceRestEntity entity, @QueryParam(value="xoauth_requestor_id") String username) throws BlueprintIllegalArgumentException {
        if (this.hasPermittedOAuthScope("JSM_KB") && username != null) {
            AuthenticatedUserThreadLocal.setUser((User)this.userAccessor.getUser(username));
        }
        BlueprintSpace space = this.spaceBlueprintService.createSpace(entity, this.getUser());
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        return new BlueprintSpaceEntity(space, baseUrl);
    }

    @POST
    @Path(value="create-personal-space")
    @Consumes(value={"application/json", "application/xml"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public BlueprintSpaceEntity createPersonalSpace(CreatePersonalSpaceRestEntity entity) {
        this.checkNullEntity(entity);
        BlueprintSpace space = this.spaceBlueprintService.createPersonalSpace(entity, this.getUser());
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        return new BlueprintSpaceEntity(space, baseUrl);
    }

    @GET
    @Path(value="byKey/{key}")
    @ScopesAllowed(requiredScope={"READ_ALL", "READ", "JSM_KB"})
    public SpaceBlueprint getByModuleCompleteKey(@PathParam(value="key") String moduleCompleteKey, @QueryParam(value="xoauth_requestor_id") String username) {
        if (this.hasPermittedOAuthScope("JSM_KB") && username != null) {
            AuthenticatedUserThreadLocal.setUser((User)this.userAccessor.getUser(username));
        }
        this.checkReadOnlyAdminPermission(false);
        this.checkEmptyParameter(moduleCompleteKey, PARAM_KEY);
        return (SpaceBlueprint)this.spaceBlueprintManager.getCloneByModuleCompleteKey(new ModuleCompleteKey(moduleCompleteKey));
    }

    @GET
    @Path(value="get/{id}")
    @ScopesAllowed(requiredScope={"READ"})
    public SpaceBlueprint get(@PathParam(value="id") UUID id) {
        this.checkAdminPermission();
        this.checkNullParameter(id, PARAM_ID);
        return (SpaceBlueprint)this.spaceBlueprintManager.getById(id);
    }

    @GET
    @Path(value="list")
    @ScopesAllowed(requiredScope={"READ"})
    public List<SpaceBlueprint> getAllSpaceBlueprints() {
        this.checkAdminPermission();
        return this.spaceBlueprintManager.getAll();
    }

    @PUT
    @ReadOnlyAccessAllowed
    @Path(value="save")
    @Consumes(value={"application/json", "application/xml"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public SpaceBlueprint save(SpaceBlueprint blueprint) {
        this.checkAdminPermission();
        return this.spaceBlueprintManager.update(blueprint);
    }

    @POST
    @ReadOnlyAccessAllowed
    @Path(value="create")
    @Consumes(value={"application/json", "application/xml"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public SpaceBlueprint create(@Nonnull SpaceBlueprintEntity entity) {
        UuidBackedAo newHomePage;
        this.checkAdminPermission();
        UUID homePageId = entity.getHomePageId();
        Long homePageTemplateId = entity.getHomePageTemplateId();
        if (homePageId != null) {
            ContentTemplateRef contentTemplateRef = (ContentTemplateRef)this.contentTemplateRefManager.getById(homePageId);
            if (contentTemplateRef == null) {
                throw new ResourceException("The specified homePageId was not found", Response.Status.NOT_FOUND, ResourceErrorType.NOT_FOUND_CONTENT_TEMPLATE_REF, (Object)homePageId);
            }
            newHomePage = this.createContentTemplateRefAo(contentTemplateRef);
        } else {
            newHomePage = homePageTemplateId != null && homePageTemplateId > 0L ? this.createContentTemplateRefAo(new ContentTemplateRef(null, homePageTemplateId, null, null, false, null)) : null;
        }
        UUID newHomePageId = newHomePage != null ? UUID.fromString(newHomePage.getUuid()) : null;
        return this.spaceBlueprintManager.create(entity.getSpaceBlueprint(), newHomePageId);
    }

    private ContentTemplateRefAo createContentTemplateRefAo(@Nonnull ContentTemplateRef contentTemplateRef) {
        return (ContentTemplateRefAo)this.activeObjects.executeInTransaction(() -> this.doCreateContentTemplateRefAo(contentTemplateRef, null));
    }

    @Nonnull
    private ContentTemplateRefAo doCreateContentTemplateRefAo(@Nonnull ContentTemplateRef contentTemplateRef, @Nullable ContentTemplateRefAo parent) {
        PageTemplate pageTemplate = this.pageTemplateHelper.getPageTemplate(contentTemplateRef);
        pageTemplate.setId(0L);
        this.pageTemplateManager.savePageTemplate(pageTemplate, null);
        ArrayList<ContentTemplateRef> children = new ArrayList<ContentTemplateRef>(contentTemplateRef.getChildren());
        contentTemplateRef.getChildren().clear();
        ContentTemplateRefAo result = (ContentTemplateRefAo)this.contentTemplateRefManager.createAo(contentTemplateRef);
        result.setParent(parent);
        result.setTemplateId(pageTemplate.getId());
        result.save();
        for (ContentTemplateRef child : children) {
            this.doCreateContentTemplateRefAo(child, result);
        }
        return result;
    }

    @DELETE
    @ReadOnlyAccessAllowed
    @Path(value="deleteAll")
    @ScopesAllowed(requiredScope={"WRITE"})
    public int deleteAll() {
        this.checkAdminPermission();
        return this.spaceBlueprintManager.deleteAll();
    }
}

