/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.rest;

import com.atlassian.confluence.plugins.createcontent.rest.SpaceResultsEntity;
import com.atlassian.confluence.plugins.createcontent.rest.entities.SpaceEntity;
import com.atlassian.confluence.spaces.Space;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SpaceResultsEntityBuilder {
    private final Set<Space> spaces = new LinkedHashSet<Space>();
    private final int resultsLimit;
    private final Predicate<? super Space> spaceFilter;
    private boolean allSpacesAdded = true;

    public SpaceResultsEntityBuilder(int resultsLimit, Predicate<Space> spaceFilter) {
        this.resultsLimit = resultsLimit;
        this.spaceFilter = spaceFilter;
    }

    private static <T> boolean addUntilLimitReached(Collection<T> destination, Iterable<T> source, int destinationSizeLimit) {
        for (T item : source) {
            if (destination.size() < destinationSizeLimit) {
                destination.add(item);
                continue;
            }
            return false;
        }
        return true;
    }

    public SpaceResultsEntityBuilder addSpaces(Space ... spaces) {
        return this.addSpaces(Arrays.asList(spaces));
    }

    public SpaceResultsEntityBuilder addSpaces(Collection<Space> newSpaces) {
        this.allSpacesAdded &= SpaceResultsEntityBuilder.addUntilLimitReached(this.spaces, newSpaces.stream().filter(this.spaceFilter).collect(Collectors.toCollection(LinkedHashSet::new)), this.resultsLimit);
        return this;
    }

    public Set<Space> getSpaces() {
        return this.spaces;
    }

    public SpaceResultsEntity build() {
        return new SpaceResultsEntity(this.spaces.stream().map(SpaceEntity.spaceTransformer()).collect(Collectors.toList()), this.resultsLimit, !this.allSpacesAdded);
    }
}

