/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.rest.entities;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.HtmlUtil;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Objects;
import java.util.function.Function;

@XmlRootElement
public class SpaceEntity {
    @XmlElement
    private String id;
    @XmlElement
    private String text;

    private SpaceEntity() {
    }

    public SpaceEntity(Space space) {
        this(space.getKey(), space.getDisplayTitle());
    }

    SpaceEntity(String id, String text) {
        this.id = id;
        this.text = HtmlUtil.htmlEncode((String)text);
    }

    public String getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpaceEntity that = (SpaceEntity)o;
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        return Objects.equals(this.text, that.text);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.id;
    }

    public static Function<Space, SpaceEntity> spaceTransformer() {
        return SpaceEntity::new;
    }
}

