/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.scheduled;

import bucket.user.propertyset.BucketPropertySetItem;
import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.core.ContentTypeAware;
import com.atlassian.confluence.dmz.propertyset.BucketPropertySetManager;
import com.atlassian.confluence.persistence.JpaQueryFactory;
import com.atlassian.confluence.plugins.createcontent.api.services.ContentBlueprintSanitiserManager;
import com.atlassian.confluence.plugins.createcontent.rest.entities.CreateBlueprintPageRestEntity;
import com.atlassian.confluence.plugins.createcontent.services.model.CreateBlueprintPageEntity;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.util.ObjectMapperProvider;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import jakarta.persistence.Query;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="createBlueprintPageEntityCleanupJob")
public class CreateBlueprintDraftPageEntityCleanupJob
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(CreateBlueprintDraftPageEntityCleanupJob.class);
    private static final String JOB_BATCH_SIZE_KEY = CreateBlueprintDraftPageEntityCleanupJob.class.getSimpleName() + "-batchSize";
    public static final String CLEANED_RECORD_KEY = "create.blueprint.page.draft.cleaned";
    @VisibleForTesting
    static final String LATEST_CLEANED_VERSION = "3";
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private static final String getEntitiesToCleanupQueryString = "select item from BucketPropertySetItem item where item.key = :entityKey and not exists ( select 1 from BucketPropertySetItem item2 where item.entityId = item2.entityId and item2.key = :cleanedRecordKey and item2.stringVal = :cleanVal)";
    private final TransactionTemplate transactionTemplate;
    private final JpaQueryFactory jpaQueryFactory;
    private final BucketPropertySetManager bucketPropertySetManager;
    private final ContentBlueprintSanitiserManager sanitiserManager;
    private final ContentPropertyManager contentPropertyManager;
    private final ContentEntityManager contentEntityManager;
    private final ObjectMapperProvider objectMapperProvider;

    @Autowired
    public CreateBlueprintDraftPageEntityCleanupJob(@ComponentImport JpaQueryFactory jpaQueryFactory, @ComponentImport BucketPropertySetManager bucketPropertySetManager, @ComponentImport TransactionTemplate transactionTemplate, ContentBlueprintSanitiserManager sanitiserManager, @ComponentImport ContentPropertyManager contentPropertyManager, @ComponentImport @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager, @ComponentImport ObjectMapperProvider objectMapperProvider) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.transactionTemplate = transactionTemplate;
        this.sanitiserManager = sanitiserManager;
        this.contentPropertyManager = contentPropertyManager;
        this.contentEntityManager = contentEntityManager;
        this.bucketPropertySetManager = bucketPropertySetManager;
        this.objectMapperProvider = objectMapperProvider;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        return (JobRunnerResponse)this.transactionTemplate.execute(() -> {
            try {
                List<BucketPropertySetItem> propertySetItems = this.getEntitiesToCleanup();
                if (!propertySetItems.isEmpty()) {
                    int totalCleaned = this.performCleanup(propertySetItems);
                    String summaryMessage = String.format("Cleaned up %d entries in %d ms", totalCleaned, System.currentTimeMillis() - jobRunnerRequest.getStartTime().getTime());
                    return JobRunnerResponse.success((String)summaryMessage);
                }
                return JobRunnerResponse.success((String)"No entries were found to cleanup");
            }
            catch (RuntimeException e) {
                return JobRunnerResponse.failed((Throwable)e);
            }
        });
    }

    private List<BucketPropertySetItem> getEntitiesToCleanup() {
        int batchSize = this.getCurrentBatchSize().orElse(1000);
        JpaQuery getEntitiesToCleanupQuery = this.createJpaQuery(getEntitiesToCleanupQueryString).setParameter("entityKey", "create.blueprint.page.draft.request").setParameter("cleanedRecordKey", CLEANED_RECORD_KEY).setParameter("cleanVal", LATEST_CLEANED_VERSION).setMaxResults(batchSize);
        return getEntitiesToCleanupQuery.getResultList();
    }

    @VisibleForTesting
    int performCleanup(List<BucketPropertySetItem> entriesToClean) {
        int cleanedCount = 0;
        ObjectMapper objectMapper = this.objectMapperProvider.getObjectMapper();
        for (BucketPropertySetItem propertySetItem : entriesToClean) {
            ContentEntityObject ceo = this.contentEntityManager.getById(propertySetItem.getEntityId());
            if (ceo != null) {
                if (!ceo.isDraft() && !ContentTypeEnum.DRAFT.equals((Object)ContentTypeEnum.forEntity((ContentTypeAware)ceo))) continue;
                String entityString = propertySetItem.getTextVal();
                try {
                    CreateBlueprintPageEntity entity = (CreateBlueprintPageEntity)objectMapper.readValue(entityString, CreateBlueprintPageRestEntity.class);
                    propertySetItem.setTextVal(objectMapper.writeValueAsString((Object)this.sanitiserManager.sanitise(entity)));
                    this.bucketPropertySetManager.save(propertySetItem);
                    this.contentPropertyManager.setStringProperty(ceo, CLEANED_RECORD_KEY, LATEST_CLEANED_VERSION);
                    ++cleanedCount;
                }
                catch (IOException e) {
                    log.error("Could not process the CreateBlueprintPageEntity for cleanup: ", (Throwable)e);
                }
                continue;
            }
            this.bucketPropertySetManager.delete(propertySetItem);
            ++cleanedCount;
        }
        return cleanedCount;
    }

    @VisibleForTesting
    Optional<Integer> getCurrentBatchSize() {
        return Optional.ofNullable(System.getProperty(JOB_BATCH_SIZE_KEY)).map(Integer::parseInt);
    }

    private JpaQuery createJpaQuery(CharSequence ql) {
        Query query = this.jpaQueryFactory.createQuery(ql.toString());
        return JpaQuery.wrap((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1), arg_0 -> ((Query)query).setMaxResults(arg_0), () -> ((Query)query).getResultList());
    }

    static interface JpaQuery {
        public JpaQuery setParameter(String var1, Object var2);

        public List<BucketPropertySetItem> getResultList();

        public JpaQuery setMaxResults(int var1);

        public static JpaQuery wrap(final BiConsumer<String, Object> parameterSetter, final Consumer<Integer> maxResultsSetter, final Supplier<List<BucketPropertySetItem>> resultGetter) {
            return new JpaQuery(){

                @Override
                public JpaQuery setParameter(String paramName, Object paramValue) {
                    parameterSetter.accept(paramName, paramValue);
                    return this;
                }

                @Override
                public List<BucketPropertySetItem> getResultList() {
                    return (List)resultGetter.get();
                }

                @Override
                public JpaQuery setMaxResults(int maxResults) {
                    maxResultsSetter.accept(maxResults);
                    return this;
                }
            };
        }
    }
}

