/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.template;

import com.atlassian.confluence.plugins.createcontent.api.contextproviders.BlueprintContextKeys;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.api.descriptors.WebItemModuleDescriptor;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public class BlueprintsDisabledPredicate
implements Predicate<ModuleDescriptor> {
    private final PluginAccessor pluginAccessor;

    public BlueprintsDisabledPredicate(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public boolean test(ModuleDescriptor moduleDescriptor) {
        if (!(moduleDescriptor instanceof WebItemModuleDescriptor)) {
            return false;
        }
        String webItemBlueprintKey = (String)moduleDescriptor.getParams().get(BlueprintContextKeys.BLUEPRINT_MODULE_KEY.key());
        boolean webItemHasBlueprint = StringUtils.isNotBlank((CharSequence)webItemBlueprintKey);
        if (!webItemHasBlueprint) {
            return false;
        }
        if (!this.pluginAccessor.isPluginEnabled(moduleDescriptor.getPluginKey())) {
            return false;
        }
        return !this.pluginAccessor.isPluginModuleEnabled(moduleDescriptor.getCompleteKey());
    }
}

