/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.upgrade;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.NoParentBandanaContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={PluginUpgradeTask.class})
public class BandanaRemovalUpgradeTask
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(BandanaRemovalUpgradeTask.class);
    private final BandanaManager bandanaManager;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final SpaceManager spaceManager;

    @Autowired
    public BandanaRemovalUpgradeTask(@ComponentImport BandanaManager bandanaManager, @ComponentImport @Qualifier(value="extendedPluginSettingsFactory") PluginSettingsFactory pluginSettingsFactory, @ComponentImport SpaceManager spaceManager) {
        this.bandanaManager = bandanaManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.spaceManager = spaceManager;
    }

    public int getBuildNumber() {
        return 21;
    }

    public String getShortDescription() {
        return "Migrate Bandana records to Plugin Settings";
    }

    public Collection<Message> doUpgrade() {
        log.info("Migrating Bandana records for promoted blueprints");
        List allSpaces = this.spaceManager.getAllSpaces();
        for (Space space : allSpaces) {
            List promotedBlueprintsIds = (List)this.bandanaManager.getValue((BandanaContext)new NoParentBandanaContext(this.getNamespace(space.getKey())), "promotedTemplates");
            if (promotedBlueprintsIds == null) continue;
            List<String> convertedList = promotedBlueprintsIds.stream().map(String::valueOf).toList();
            this.pluginSettingsFactory.createSettingsForKey(this.getNamespace(space.getKey())).put("promotedTemplates", convertedList);
        }
        return List.of();
    }

    private String getNamespace(String spaceKey) {
        return "com.atlassian.confluence.blueprints.plugin-module-state:" + spaceKey;
    }

    public String getPluginKey() {
        return "com.atlassian.confluence.plugins.confluence-create-content-plugin";
    }
}

