/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.upgrade;

import com.atlassian.confluence.api.service.settings.ExtendedPluginSettings;
import com.atlassian.confluence.api.service.settings.ExtendedPluginSettingsFactory;
import com.atlassian.confluence.plugins.createcontent.BlueprintStateController;
import com.atlassian.confluence.plugins.createcontent.ContentBlueprintManager;
import com.atlassian.confluence.plugins.createcontent.api.contextproviders.BlueprintContextKeys;
import com.atlassian.confluence.plugins.createcontent.impl.ContentBlueprint;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.api.descriptors.WebItemModuleDescriptor;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={PluginUpgradeTask.class})
public class SpaceLevelDisabledBlueprintsUpgradeTask
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(SpaceLevelDisabledBlueprintsUpgradeTask.class);
    private static final String CREATE_DIALOG_CONTENT_SECTION = "system.create.dialog/content";
    private final ExtendedPluginSettingsFactory pluginSettingsFactory;
    private final ContentBlueprintManager contentBlueprintManager;
    private final SpaceManager spaceManager;
    private final DynamicWebInterfaceManager webInterfaceManager;
    private final BlueprintStateController blueprintStateController;

    @Autowired
    public SpaceLevelDisabledBlueprintsUpgradeTask(@ComponentImport ExtendedPluginSettingsFactory pluginSettingsFactory, ContentBlueprintManager contentBlueprintManager, @ComponentImport SpaceManager spaceManager, @ComponentImport DynamicWebInterfaceManager webInterfaceManager, BlueprintStateController blueprintStateController) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.contentBlueprintManager = contentBlueprintManager;
        this.spaceManager = spaceManager;
        this.webInterfaceManager = webInterfaceManager;
        this.blueprintStateController = blueprintStateController;
    }

    public int getBuildNumber() {
        return 3;
    }

    public String getShortDescription() {
        return "Updates the Plugin Settings entries for space-level disabled blueprints, so they are referenced using UUIDs.";
    }

    public Collection<Message> doUpgrade() {
        List allSpaces = this.spaceManager.getAllSpaces();
        List enabledWebItems = this.webInterfaceManager.getItems(CREATE_DIALOG_CONTENT_SECTION).stream().filter(webItem -> {
            if (webItem == null) {
                return false;
            }
            String moduleKey = (String)webItem.getParams().get(BlueprintContextKeys.BLUEPRINT_MODULE_KEY.key());
            if (moduleKey == null) {
                log.warn("Can't find module key for web item {}", webItem);
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        for (Space space : allSpaces) {
            this.updateSpaceDisabledBlueprints(space, enabledWebItems);
        }
        return null;
    }

    private void updateSpaceDisabledBlueprints(Space space, Iterable<? extends WebItemModuleDescriptor> enabledWebItems) {
        ExtendedPluginSettings pluginSettings = this.pluginSettingsFactory.createSettingsForKey(this.getNamespace(space));
        Set spaceDisabledWebItemModuleCompleteKeys = pluginSettings.getKeys();
        if (!spaceDisabledWebItemModuleCompleteKeys.iterator().hasNext()) {
            return;
        }
        HashSet<UUID> spaceDisabledBlueprintIds = new HashSet<UUID>();
        for (String disabledWebItemModuleCompleteKey : spaceDisabledWebItemModuleCompleteKeys) {
            ModuleCompleteKey blueprintModuleCompleteKey = this.findBlueprintModuleCompleteKey(enabledWebItems, disabledWebItemModuleCompleteKey);
            if (blueprintModuleCompleteKey != null) {
                ContentBlueprint contentBlueprint = this.contentBlueprintManager.getOrCreateCustomBlueprint(blueprintModuleCompleteKey, space);
                spaceDisabledBlueprintIds.add(contentBlueprint.getId());
            }
            pluginSettings.remove(disabledWebItemModuleCompleteKey);
        }
        this.blueprintStateController.disableBlueprints(spaceDisabledBlueprintIds, space);
    }

    private String getNamespace(Space space) {
        return "com.atlassian.confluence.blueprints.plugin-module-state:" + space.getKey();
    }

    private ModuleCompleteKey findBlueprintModuleCompleteKey(Iterable<? extends WebItemModuleDescriptor> webItems, String webItemModuleCompleteKey) {
        for (WebItemModuleDescriptor webItemModuleDescriptor : webItems) {
            if (!webItemModuleCompleteKey.equals(webItemModuleDescriptor.getCompleteKey())) continue;
            String moduleKey = (String)webItemModuleDescriptor.getParams().get(BlueprintContextKeys.BLUEPRINT_MODULE_KEY.key());
            return new ModuleCompleteKey(webItemModuleDescriptor.getPluginKey(), moduleKey);
        }
        return null;
    }

    public String getPluginKey() {
        return "com.atlassian.confluence.plugins.confluence-create-content-plugin";
    }
}

