/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.parentsoftware.api;

import com.atlassian.marketplace.parentsoftware.ApiClient;
import com.atlassian.marketplace.parentsoftware.ApiException;
import com.atlassian.marketplace.parentsoftware.Configuration;
import com.atlassian.marketplace.parentsoftware.Pair;
import com.atlassian.marketplace.parentsoftware.model.ParentSoftwareVersionCreateRequest;
import com.atlassian.marketplace.parentsoftware.model.ParentSoftwareVersionGetResponse;
import com.atlassian.marketplace.parentsoftware.model.ParentSoftwareVersionUpdateRequest;
import com.atlassian.marketplace.parentsoftware.model.ParentSoftwareVersionsGetResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.HashMap;

public class ParentSoftwareVersionApisApi {
    private ApiClient apiClient;

    public ParentSoftwareVersionApisApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ParentSoftwareVersionApisApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void createParentSoftwareVersion(String id, ParentSoftwareVersionCreateRequest parentSoftwareVersionCreateRequest) throws ApiException {
        ParentSoftwareVersionCreateRequest localVarPostBody = parentSoftwareVersionCreateRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling createParentSoftwareVersion");
        }
        if (parentSoftwareVersionCreateRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'parentSoftwareVersionCreateRequest' when calling createParentSoftwareVersion");
        }
        String localVarPath = "/parent-software/{id}/versions".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public Object deleteParentSoftwareVersion(String id, Long buildNumber) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteParentSoftwareVersion");
        }
        if (buildNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'buildNumber' when calling deleteParentSoftwareVersion");
        }
        String localVarPath = "/parent-software/{id}/versions/build/{buildNumber}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString())).replaceAll("\\{buildNumber\\}", this.apiClient.escapeString(buildNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<Object> localVarReturnType = new TypeReference<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ParentSoftwareVersionGetResponse getParentSoftwareVersionByBuildNumber(String id, Long buildNumber) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getParentSoftwareVersionByBuildNumber");
        }
        if (buildNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'buildNumber' when calling getParentSoftwareVersionByBuildNumber");
        }
        String localVarPath = "/parent-software/{id}/versions/build/{buildNumber}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString())).replaceAll("\\{buildNumber\\}", this.apiClient.escapeString(buildNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<ParentSoftwareVersionGetResponse> localVarReturnType = new TypeReference<ParentSoftwareVersionGetResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ParentSoftwareVersionGetResponse getParentSoftwareVersionByVersionNumber(String id, String versionNumber) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getParentSoftwareVersionByVersionNumber");
        }
        if (versionNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'versionNumber' when calling getParentSoftwareVersionByVersionNumber");
        }
        String localVarPath = "/parent-software/{id}/versions/number/{versionNumber}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString())).replaceAll("\\{versionNumber\\}", this.apiClient.escapeString(versionNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<ParentSoftwareVersionGetResponse> localVarReturnType = new TypeReference<ParentSoftwareVersionGetResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ParentSoftwareVersionsGetResponse getParentSoftwareVersions(String id, Integer limit, String cursor) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getParentSoftwareVersions");
        }
        String localVarPath = "/parent-software/{id}/versions".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("cursor", cursor));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<ParentSoftwareVersionsGetResponse> localVarReturnType = new TypeReference<ParentSoftwareVersionsGetResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object updateParentSoftwareVersion(String id, Long buildNumber, ParentSoftwareVersionUpdateRequest parentSoftwareVersionUpdateRequest) throws ApiException {
        ParentSoftwareVersionUpdateRequest localVarPostBody = parentSoftwareVersionUpdateRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling updateParentSoftwareVersion");
        }
        if (buildNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'buildNumber' when calling updateParentSoftwareVersion");
        }
        if (parentSoftwareVersionUpdateRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'parentSoftwareVersionUpdateRequest' when calling updateParentSoftwareVersion");
        }
        String localVarPath = "/parent-software/{id}/versions/build/{buildNumber}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString())).replaceAll("\\{buildNumber\\}", this.apiClient.escapeString(buildNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<Object> localVarReturnType = new TypeReference<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

