/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.parentsoftware.client;

import com.atlassian.marketplace.parentsoftware.ApiClient;
import com.atlassian.marketplace.parentsoftware.api.ParentSoftwareApisApi;
import com.atlassian.marketplace.parentsoftware.api.ParentSoftwareVersionApisApi;
import com.atlassian.marketplace.parentsoftware.client.ParentSoftwareClient;
import com.atlassian.marketplace.parentsoftware.client.ParentSoftwareClientImpl;
import com.atlassian.marketplace.parentsoftware.http.HttpConfiguration;
import java.net.URI;
import java.util.Objects;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParentSoftwareClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParentSoftwareClientFactory.class);
    public static final URI DEFAULT_MARKETPLACE_URI = URI.create("https://marketplace.atlassian.com");
    private static final String API_VERSION = "1";

    private ParentSoftwareClientFactory() {
    }

    public static ParentSoftwareClient createParentsSoftwareClient(URI baseUri, HttpConfiguration configuration, boolean isDevMode) {
        ApiClient client = new ApiClient();
        URI apiUri = URI.create(Objects.requireNonNull(baseUri, "Server base URL") + "/rest/1");
        LOGGER.info("Building ParentSoftwareClient with URI : {}", (Object)apiUri);
        HttpClientBuilder builder = configuration.httpClientBuilder(apiUri);
        client.setBasePath(apiUri.toString());
        client.setHttpClient(builder.build());
        return new ParentSoftwareClientImpl(new ParentSoftwareApisApi(client), new ParentSoftwareVersionApisApi(client), isDevMode);
    }

    public static ParentSoftwareClient createParentsSoftwareClient(URI baseUri, boolean isDevMode) {
        return ParentSoftwareClientFactory.createParentsSoftwareClient(baseUri, HttpConfiguration.defaults(), isDevMode);
    }

    public static ParentSoftwareClient createParentsSoftwareClient(HttpConfiguration configuration, boolean isDevMode) {
        return ParentSoftwareClientFactory.createParentsSoftwareClient(DEFAULT_MARKETPLACE_URI, configuration, isDevMode);
    }

    public static ParentSoftwareClient createParentsSoftwareClient(boolean isDevMode) {
        return ParentSoftwareClientFactory.createParentsSoftwareClient(DEFAULT_MARKETPLACE_URI, isDevMode);
    }
}

