/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.parentsoftware.http;

import com.atlassian.marketplace.parentsoftware.http.HeadersProvider;
import com.atlassian.marketplace.parentsoftware.http.HttpConfiguration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.AuthCache;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestInterceptor
implements HttpRequestInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRequestInterceptor.class);
    private final HttpConfiguration config;
    private final HttpHost proxyHost;

    DefaultRequestInterceptor(HttpConfiguration config, HttpHost proxyHost) {
        this.config = Objects.requireNonNull(config, "HttpConfiguration must not be null");
        this.proxyHost = proxyHost;
    }

    public void process(HttpRequest request, HttpContext context) {
        this.config.getRequestDecorator().map(HeadersProvider::getRequestHeaders).ifPresent(requestHeaders -> requestHeaders.forEach((arg_0, arg_1) -> ((HttpRequest)request).addHeader(arg_0, arg_1)));
        CountingAuthCache authCache = new CountingAuthCache();
        if (this.config.hasCredentials()) {
            this.addSimpleAuthCache(authCache, context);
        }
        this.config.getProxyConfiguration().ifPresent(pc -> this.addProxyAuthCache((HttpConfiguration.ProxyConfiguration)pc, authCache));
        authCache.unwrap().ifPresent(ac -> context.setAttribute("http.auth.auth-cache", ac));
    }

    private void addSimpleAuthCache(AuthCache authCache, HttpContext context) {
        HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
        if (targetHost != null) {
            authCache.put(targetHost, (AuthScheme)new BasicScheme());
        }
    }

    private void addProxyAuthCache(HttpConfiguration.ProxyConfiguration proxyConfiguration, AuthCache authCache) {
        HttpConfiguration.ProxyAuthParams authParams;
        if (proxyConfiguration.getAuthParams() != null && (authParams = proxyConfiguration.getAuthParams()).getAuthMethod() == HttpConfiguration.ProxyAuthMethod.BASIC && this.proxyHost != null) {
            BasicScheme proxyAuth = new BasicScheme();
            try {
                proxyAuth.processChallenge((Header)new BasicHeader("Proxy-Authenticate", "BASIC realm=default"));
                authCache.put(this.proxyHost, (AuthScheme)proxyAuth);
            }
            catch (Exception e) {
                LOGGER.warn("Error, unable to set preemptive proxy auth: {}", (Object)e.getMessage(), (Object)e);
                LOGGER.debug(e.toString(), (Throwable)e);
            }
        }
    }

    private static class CountingAuthCache
    implements AuthCache {
        private final Set<HttpHost> hosts = new HashSet<HttpHost>();
        private final BasicAuthCache delegate = new BasicAuthCache();

        private CountingAuthCache() {
        }

        private boolean isEmpty() {
            return this.hosts.isEmpty();
        }

        public void put(HttpHost host, AuthScheme authScheme) {
            this.hosts.add(host);
            this.delegate.put(host, authScheme);
        }

        public AuthScheme get(HttpHost host) {
            return this.delegate.get(host);
        }

        public void remove(HttpHost host) {
            this.hosts.remove(host);
            this.delegate.remove(host);
        }

        public void clear() {
            this.delegate.clear();
        }

        public Optional<AuthCache> unwrap() {
            return this.isEmpty() ? Optional.empty() : Optional.of(this.delegate);
        }
    }
}

