/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.parentsoftware.http;

import com.atlassian.marketplace.parentsoftware.http.DefaultCredentialsProvider;
import com.atlassian.marketplace.parentsoftware.http.DefaultRequestInterceptor;
import com.atlassian.marketplace.parentsoftware.http.HeadersProvider;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;

public class HttpConfiguration {
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 15000;
    public static final int DEFAULT_READ_TIMEOUT_MILLIS = 15000;
    public static final int DEFAULT_MAX_CONNECTIONS = 10;
    public static final int DEFAULT_MAX_CACHE_ENTRIES = 100;
    public static final long DEFAULT_MAX_CACHE_OBJECT_SIZE = 60000L;
    private final int connectTimeoutMillis;
    private final int readTimeoutMillis;
    private final int maxConnections;
    private final int maxCacheEntries;
    private final long maxCacheObjectSize;
    private final Optional<Credentials> credentials;
    private final Optional<Integer> maxRedirects;
    private final Optional<ProxyConfiguration> proxy;
    private final Optional<HeadersProvider> requestDecorator;

    public static Builder builder() {
        return new Builder();
    }

    public static HttpConfiguration defaults() {
        return HttpConfiguration.builder().build();
    }

    private HttpConfiguration(Builder builder) {
        this.connectTimeoutMillis = builder.connectTimeoutMillis;
        this.readTimeoutMillis = builder.readTimeoutMillis;
        this.maxConnections = builder.maxConnections;
        this.maxCacheEntries = builder.maxCacheEntries;
        this.maxCacheObjectSize = builder.maxCacheObjectSize;
        this.credentials = builder.credentials;
        this.maxRedirects = builder.maxRedirects;
        this.proxy = builder.proxy;
        this.requestDecorator = builder.headersProvider;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    public long getMaxCacheObjectSize() {
        return this.maxCacheObjectSize;
    }

    public Optional<Integer> getMaxRedirects() {
        return this.maxRedirects;
    }

    public Optional<Credentials> getCredentials() {
        return this.credentials;
    }

    public boolean hasCredentials() {
        return this.credentials.isPresent();
    }

    public Optional<ProxyConfiguration> getProxyConfiguration() {
        return this.proxy;
    }

    public boolean hasProxy() {
        return this.proxy.isPresent();
    }

    public Optional<HeadersProvider> getRequestDecorator() {
        return this.requestDecorator;
    }

    private Optional<HttpHost> getProxyHostFromURI(URI uri) {
        String property;
        String prefix = "https";
        if (uri.getScheme() != null && uri.getScheme().equalsIgnoreCase("http")) {
            prefix = "http";
        }
        if ((property = (String)Optional.ofNullable(System.getProperty(prefix + ".proxyHost")).map(String::trim).orElse(null)) != null && !property.isEmpty()) {
            int port = Integer.parseInt(System.getProperty(prefix + ".proxyPort", String.valueOf(80)));
            return Optional.of(new HttpHost(property, port));
        }
        return Optional.empty();
    }

    Optional<HttpHost> getRealProxyHost(URI baseUri) {
        Optional<ProxyConfiguration> config = this.getProxyConfiguration();
        if (config.isPresent()) {
            return config.map(ProxyConfiguration::getProxyHost).map(ph -> new HttpHost(ph.getHostname(), ph.getPort())).or(() -> this.getProxyHostFromURI(baseUri));
        }
        return Optional.empty();
    }

    public HttpClientBuilder httpClientBuilder(URI baseUri) {
        return this.httpClientBuilder(baseUri, CachingBehavior.CACHING);
    }

    public HttpClientBuilder httpClientBuilder(URI baseUri, CachingBehavior cachingBehavior) {
        HttpClientBuilder builder;
        if (cachingBehavior == CachingBehavior.CACHING) {
            CachingHttpClientBuilder cachingBuilder = CachingHttpClientBuilder.create();
            CacheConfig.Builder configBuilder = CacheConfig.custom();
            configBuilder.setSharedCache(false);
            configBuilder.setMaxCacheEntries(this.getMaxCacheEntries());
            configBuilder.setMaxObjectSize(this.getMaxCacheObjectSize());
            cachingBuilder.setCacheConfig(configBuilder.build());
            builder = cachingBuilder;
        } else {
            builder = HttpClientBuilder.create();
        }
        builder.useSystemProperties();
        builder.setMaxConnPerRoute(this.getMaxConnections());
        RequestConfig.Builder rc = RequestConfig.custom().setConnectTimeout(this.getConnectTimeoutMillis()).setSocketTimeout(this.getReadTimeoutMillis()).setCookieSpec("ignoreCookies");
        this.getProxyConfiguration().map(ProxyConfiguration::getProxyPreferredAuthSchemes).ifPresent(arg_0 -> ((RequestConfig.Builder)rc).setProxyPreferredAuthSchemes(arg_0));
        this.getMaxRedirects().ifPresent(arg_0 -> ((RequestConfig.Builder)rc).setMaxRedirects(arg_0));
        builder.setDefaultRequestConfig(rc.build());
        HttpHost realProxyHost = this.getRealProxyHost(baseUri).orElse(null);
        if (realProxyHost != null) {
            builder.setProxy(realProxyHost);
        }
        builder.addInterceptorFirst((HttpRequestInterceptor)new DefaultRequestInterceptor(this, realProxyHost));
        builder.setDefaultCredentialsProvider((CredentialsProvider)new DefaultCredentialsProvider(this, realProxyHost));
        builder.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.getConnectTimeoutMillis()).build());
        return builder;
    }

    public static class Builder {
        private int connectTimeoutMillis = 15000;
        private int readTimeoutMillis = 15000;
        private int maxConnections = 10;
        private int maxCacheEntries = 100;
        private long maxCacheObjectSize = 60000L;
        private Optional<Credentials> credentials = Optional.empty();
        private Optional<Integer> maxRedirects = Optional.empty();
        private Optional<ProxyConfiguration> proxy = Optional.empty();
        private Optional<HeadersProvider> headersProvider = Optional.empty();

        public HttpConfiguration build() {
            return new HttpConfiguration(this);
        }

        public Builder connectTimeoutMillis(Integer connectTimeoutMillis) {
            this.connectTimeoutMillis = connectTimeoutMillis == null ? 15000 : connectTimeoutMillis;
            return this;
        }

        public Builder readTimeoutMillis(Integer readTimeoutMillis) {
            this.readTimeoutMillis = readTimeoutMillis == null ? 15000 : readTimeoutMillis;
            return this;
        }

        public Builder maxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder maxCacheEntries(int maxCacheEntries) {
            this.maxCacheEntries = maxCacheEntries;
            return this;
        }

        public Builder maxCacheObjectSize(long maxCacheObjectSize) {
            this.maxCacheObjectSize = maxCacheObjectSize;
            return this;
        }

        public Builder maxRedirects(Optional<Integer> maxRedirects) {
            this.maxRedirects = Objects.requireNonNull(maxRedirects);
            return this;
        }

        public Builder credentials(Optional<Credentials> credentials) {
            this.credentials = Objects.requireNonNull(credentials);
            return this;
        }

        public Builder proxyConfiguration(ProxyConfiguration proxy) {
            this.proxy = Optional.ofNullable(proxy);
            return this;
        }

        public Builder headers(Optional<HeadersProvider> requestDecorator) {
            this.headersProvider = Objects.requireNonNull(requestDecorator);
            return this;
        }
    }

    public static class ProxyHost {
        public static final int DEFAULT_PORT = 80;
        private final String hostname;
        private final int port;

        public ProxyHost(String hostname, int port) {
            this.hostname = Objects.requireNonNull(hostname);
            this.port = port;
        }

        public ProxyHost(String hostname) {
            this(hostname, 80);
        }

        public String getHostname() {
            return this.hostname;
        }

        public int getPort() {
            return this.port;
        }

        public String toString() {
            return this.hostname + ":" + this.port;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ProxyHost)) {
                return false;
            }
            ProxyHost proxyHost = (ProxyHost)o;
            return this.getPort() == proxyHost.getPort() && Objects.equals(this.getHostname(), proxyHost.getHostname());
        }

        public int hashCode() {
            return Objects.hash(this.getHostname(), this.getPort());
        }
    }

    public static enum CachingBehavior {
        NO_CACHING,
        CACHING;

    }

    public static enum ProxyAuthMethod {
        BASIC,
        DIGEST,
        NTLM;


        public static Optional<ProxyAuthMethod> fromKey(String key) {
            for (ProxyAuthMethod a : ProxyAuthMethod.values()) {
                if (!a.name().equalsIgnoreCase(key)) continue;
                return Optional.of(a);
            }
            return Optional.empty();
        }
    }

    public static class ProxyAuthParams {
        private final Credentials credentials;
        private final ProxyAuthMethod authMethod;
        private final String ntlmDomain;
        private final String ntlmWorkstation;

        public ProxyAuthParams(Credentials credentials, ProxyAuthMethod authMethod, String ntlmDomain, String ntlmWorkstation) {
            this.credentials = Objects.requireNonNull(credentials, "credentials");
            this.authMethod = Objects.requireNonNull(authMethod, "authMethod");
            this.ntlmDomain = ntlmDomain == null ? "" : ntlmDomain;
            this.ntlmWorkstation = ntlmWorkstation == null ? "" : ntlmWorkstation;
        }

        public ProxyAuthParams(Credentials credentials, ProxyAuthMethod authMethod) {
            this(credentials, authMethod, null, null);
        }

        public Credentials getCredentials() {
            return this.credentials;
        }

        public ProxyAuthMethod getAuthMethod() {
            return this.authMethod;
        }

        public String getNtlmDomain() {
            return this.ntlmDomain;
        }

        public String getNtlmWorkstation() {
            return this.ntlmWorkstation;
        }

        public String toString() {
            return "AuthParams(" + this.credentials + ", " + this.authMethod + ", " + this.ntlmDomain + ", " + this.ntlmWorkstation + ")";
        }

        public boolean equals(Object o) {
            if (!(o instanceof ProxyAuthParams)) {
                return false;
            }
            ProxyAuthParams that = (ProxyAuthParams)o;
            return Objects.equals(this.getCredentials(), that.getCredentials()) && this.getAuthMethod() == that.getAuthMethod() && Objects.equals(this.getNtlmDomain(), that.getNtlmDomain()) && Objects.equals(this.getNtlmWorkstation(), that.getNtlmWorkstation());
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getCredentials(), this.getAuthMethod(), this.getNtlmDomain(), this.getNtlmWorkstation()});
        }
    }

    public static class ProxyConfiguration {
        private final ProxyHost proxyHost;
        private final ProxyAuthParams authParams;

        public static Builder builder() {
            return new Builder();
        }

        private ProxyConfiguration(Builder builder) {
            this.proxyHost = builder.proxyHost;
            this.authParams = builder.authParams;
        }

        public ProxyHost getProxyHost() {
            return this.proxyHost;
        }

        public boolean hasAuth() {
            return this.authParams != null;
        }

        public ProxyAuthParams getAuthParams() {
            return this.authParams;
        }

        public List<String> getProxyPreferredAuthSchemes() {
            if (this.authParams == null) {
                return List.of();
            }
            return List.of(this.authParams.getAuthMethod().name().toUpperCase());
        }

        public boolean equals(Object o) {
            if (!(o instanceof ProxyConfiguration)) {
                return false;
            }
            ProxyConfiguration that = (ProxyConfiguration)o;
            return Objects.equals(this.getProxyHost(), that.getProxyHost()) && Objects.equals(this.getAuthParams(), that.getAuthParams());
        }

        public int hashCode() {
            return Objects.hash(this.getProxyHost(), this.getAuthParams());
        }

        public String toString() {
            return "ProxyConfiguration{proxyHost=" + this.proxyHost + ", authParams=" + this.authParams + "}";
        }

        public static class Builder {
            private ProxyHost proxyHost;
            private ProxyAuthParams authParams;

            public ProxyConfiguration build() {
                return new ProxyConfiguration(this);
            }

            public Builder proxyHost(ProxyHost proxyHost) {
                this.proxyHost = Objects.requireNonNull(proxyHost);
                return this;
            }

            public Builder authParams(ProxyAuthParams authParams) {
                this.authParams = Objects.requireNonNull(authParams);
                return this;
            }
        }
    }

    public static class Credentials {
        private final String username;
        private final String password;

        public Credentials(String username, String password) {
            this.username = Objects.requireNonNull(username, "username");
            this.password = Objects.requireNonNull(password, "password");
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean equals(Object other) {
            if (other instanceof Credentials) {
                Credentials o = (Credentials)other;
                return o.username.equals(this.username) && o.password.equals(this.password);
            }
            return false;
        }

        public int hashCode() {
            return this.username.hashCode() + this.password.hashCode();
        }

        public String toString() {
            return "Credentials(" + this.username + ", " + this.password + ")";
        }
    }
}

