/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.parentsoftware.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Changelog of the app software version.")
@JsonPropertyOrder(value={"releaseSummary", "releaseNotes"})
@JsonTypeName(value="AppSoftwareVersionChangelog")
public class AppSoftwareVersionChangelog {
    public static final String JSON_PROPERTY_RELEASE_SUMMARY = "releaseSummary";
    private String releaseSummary;
    public static final String JSON_PROPERTY_RELEASE_NOTES = "releaseNotes";
    private String releaseNotes;

    public AppSoftwareVersionChangelog releaseSummary(String releaseSummary) {
        this.releaseSummary = releaseSummary;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The release summary of the app software version.")
    @JsonProperty(value="releaseSummary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getReleaseSummary() {
        return this.releaseSummary;
    }

    @JsonProperty(value="releaseSummary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setReleaseSummary(String releaseSummary) {
        this.releaseSummary = releaseSummary;
    }

    public AppSoftwareVersionChangelog releaseNotes(String releaseNotes) {
        this.releaseNotes = releaseNotes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The release notes of the app software version.")
    @JsonProperty(value="releaseNotes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReleaseNotes() {
        return this.releaseNotes;
    }

    @JsonProperty(value="releaseNotes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReleaseNotes(String releaseNotes) {
        this.releaseNotes = releaseNotes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppSoftwareVersionChangelog appSoftwareVersionChangelog = (AppSoftwareVersionChangelog)o;
        return Objects.equals(this.releaseSummary, appSoftwareVersionChangelog.releaseSummary) && Objects.equals(this.releaseNotes, appSoftwareVersionChangelog.releaseNotes);
    }

    public int hashCode() {
        return Objects.hash(this.releaseSummary, this.releaseNotes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppSoftwareVersionChangelog {\n");
        sb.append("    releaseSummary: ").append(this.toIndentedString(this.releaseSummary)).append("\n");
        sb.append("    releaseNotes: ").append(this.toIndentedString(this.releaseNotes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

