/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.parentsoftware.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Compatibility of the app software version")
@JsonPropertyOrder(value={"parentSoftwareId", "minBuildNumber", "maxBuildNumber"})
@JsonTypeName(value="AppSoftwareVersionCompatibility")
public class AppSoftwareVersionCompatibility {
    public static final String JSON_PROPERTY_PARENT_SOFTWARE_ID = "parentSoftwareId";
    private String parentSoftwareId;
    public static final String JSON_PROPERTY_MIN_BUILD_NUMBER = "minBuildNumber";
    private Long minBuildNumber;
    public static final String JSON_PROPERTY_MAX_BUILD_NUMBER = "maxBuildNumber";
    private Long maxBuildNumber;

    public AppSoftwareVersionCompatibility parentSoftwareId(String parentSoftwareId) {
        this.parentSoftwareId = parentSoftwareId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The id for the parent software that the app software version is compatible with.")
    @JsonProperty(value="parentSoftwareId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getParentSoftwareId() {
        return this.parentSoftwareId;
    }

    @JsonProperty(value="parentSoftwareId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setParentSoftwareId(String parentSoftwareId) {
        this.parentSoftwareId = parentSoftwareId;
    }

    public AppSoftwareVersionCompatibility minBuildNumber(Long minBuildNumber) {
        this.minBuildNumber = minBuildNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The minimum build number of the parent software that the app software version is compatible with. Only applicable for Server and Data Center.")
    @JsonProperty(value="minBuildNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMinBuildNumber() {
        return this.minBuildNumber;
    }

    @JsonProperty(value="minBuildNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinBuildNumber(Long minBuildNumber) {
        this.minBuildNumber = minBuildNumber;
    }

    public AppSoftwareVersionCompatibility maxBuildNumber(Long maxBuildNumber) {
        this.maxBuildNumber = maxBuildNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum build number of the parent software that the app software version is compatible with. Only applicable for Server and Data Center.")
    @JsonProperty(value="maxBuildNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMaxBuildNumber() {
        return this.maxBuildNumber;
    }

    @JsonProperty(value="maxBuildNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxBuildNumber(Long maxBuildNumber) {
        this.maxBuildNumber = maxBuildNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppSoftwareVersionCompatibility appSoftwareVersionCompatibility = (AppSoftwareVersionCompatibility)o;
        return Objects.equals(this.parentSoftwareId, appSoftwareVersionCompatibility.parentSoftwareId) && Objects.equals(this.minBuildNumber, appSoftwareVersionCompatibility.minBuildNumber) && Objects.equals(this.maxBuildNumber, appSoftwareVersionCompatibility.maxBuildNumber);
    }

    public int hashCode() {
        return Objects.hash(this.parentSoftwareId, this.minBuildNumber, this.maxBuildNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppSoftwareVersionCompatibility {\n");
        sb.append("    parentSoftwareId: ").append(this.toIndentedString(this.parentSoftwareId)).append("\n");
        sb.append("    minBuildNumber: ").append(this.toIndentedString(this.minBuildNumber)).append("\n");
        sb.append("    maxBuildNumber: ").append(this.toIndentedString(this.maxBuildNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

