/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.parentsoftware.model;

import com.atlassian.marketplace.parentsoftware.model.AppSoftwareVersionChangelog;
import com.atlassian.marketplace.parentsoftware.model.AppSoftwareVersionCompatibility;
import com.atlassian.marketplace.parentsoftware.model.AppSoftwareVersionFrameworkDetails;
import com.atlassian.marketplace.parentsoftware.model.AppSoftwareVersionLicenseTypeCreateRequest;
import com.atlassian.marketplace.parentsoftware.model.SourceCodeLicense;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"buildNumber", "versionNumber", "compatibilities", "supportedPaymentModel", "frameworkDetails", "licenseType", "sourceCodeLicense", "changelog", "supported"})
@JsonTypeName(value="AppSoftwareVersionCreateRequest")
public class AppSoftwareVersionCreateRequest {
    public static final String JSON_PROPERTY_BUILD_NUMBER = "buildNumber";
    private Long buildNumber;
    public static final String JSON_PROPERTY_VERSION_NUMBER = "versionNumber";
    private String versionNumber;
    public static final String JSON_PROPERTY_COMPATIBILITIES = "compatibilities";
    private List<AppSoftwareVersionCompatibility> compatibilities = new ArrayList<AppSoftwareVersionCompatibility>();
    public static final String JSON_PROPERTY_SUPPORTED_PAYMENT_MODEL = "supportedPaymentModel";
    private SupportedPaymentModelEnum supportedPaymentModel;
    public static final String JSON_PROPERTY_FRAMEWORK_DETAILS = "frameworkDetails";
    private AppSoftwareVersionFrameworkDetails frameworkDetails;
    public static final String JSON_PROPERTY_LICENSE_TYPE = "licenseType";
    private AppSoftwareVersionLicenseTypeCreateRequest licenseType;
    public static final String JSON_PROPERTY_SOURCE_CODE_LICENSE = "sourceCodeLicense";
    private SourceCodeLicense sourceCodeLicense;
    public static final String JSON_PROPERTY_CHANGELOG = "changelog";
    private AppSoftwareVersionChangelog changelog;
    public static final String JSON_PROPERTY_SUPPORTED = "supported";
    private Boolean supported;

    public AppSoftwareVersionCreateRequest buildNumber(Long buildNumber) {
        this.buildNumber = buildNumber;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Build number for the app software version")
    @JsonProperty(value="buildNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getBuildNumber() {
        return this.buildNumber;
    }

    @JsonProperty(value="buildNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBuildNumber(Long buildNumber) {
        this.buildNumber = buildNumber;
    }

    public AppSoftwareVersionCreateRequest versionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Version number of the app software version")
    @JsonProperty(value="versionNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getVersionNumber() {
        return this.versionNumber;
    }

    @JsonProperty(value="versionNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVersionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
    }

    public AppSoftwareVersionCreateRequest compatibilities(List<AppSoftwareVersionCompatibility> compatibilities) {
        this.compatibilities = compatibilities;
        return this;
    }

    public AppSoftwareVersionCreateRequest addCompatibilitiesItem(AppSoftwareVersionCompatibility compatibilitiesItem) {
        this.compatibilities.add(compatibilitiesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Compatibility of the app software version")
    @JsonProperty(value="compatibilities")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<AppSoftwareVersionCompatibility> getCompatibilities() {
        return this.compatibilities;
    }

    @JsonProperty(value="compatibilities")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCompatibilities(List<AppSoftwareVersionCompatibility> compatibilities) {
        this.compatibilities = compatibilities;
    }

    public AppSoftwareVersionCreateRequest supportedPaymentModel(SupportedPaymentModelEnum supportedPaymentModel) {
        this.supportedPaymentModel = supportedPaymentModel;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The payment model supported by the app software version.")
    @JsonProperty(value="supportedPaymentModel")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SupportedPaymentModelEnum getSupportedPaymentModel() {
        return this.supportedPaymentModel;
    }

    @JsonProperty(value="supportedPaymentModel")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupportedPaymentModel(SupportedPaymentModelEnum supportedPaymentModel) {
        this.supportedPaymentModel = supportedPaymentModel;
    }

    public AppSoftwareVersionCreateRequest frameworkDetails(AppSoftwareVersionFrameworkDetails frameworkDetails) {
        this.frameworkDetails = frameworkDetails;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="frameworkDetails")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AppSoftwareVersionFrameworkDetails getFrameworkDetails() {
        return this.frameworkDetails;
    }

    @JsonProperty(value="frameworkDetails")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFrameworkDetails(AppSoftwareVersionFrameworkDetails frameworkDetails) {
        this.frameworkDetails = frameworkDetails;
    }

    public AppSoftwareVersionCreateRequest licenseType(AppSoftwareVersionLicenseTypeCreateRequest licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="licenseType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AppSoftwareVersionLicenseTypeCreateRequest getLicenseType() {
        return this.licenseType;
    }

    @JsonProperty(value="licenseType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLicenseType(AppSoftwareVersionLicenseTypeCreateRequest licenseType) {
        this.licenseType = licenseType;
    }

    public AppSoftwareVersionCreateRequest sourceCodeLicense(SourceCodeLicense sourceCodeLicense) {
        this.sourceCodeLicense = sourceCodeLicense;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="sourceCodeLicense")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SourceCodeLicense getSourceCodeLicense() {
        return this.sourceCodeLicense;
    }

    @JsonProperty(value="sourceCodeLicense")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceCodeLicense(SourceCodeLicense sourceCodeLicense) {
        this.sourceCodeLicense = sourceCodeLicense;
    }

    public AppSoftwareVersionCreateRequest changelog(AppSoftwareVersionChangelog changelog) {
        this.changelog = changelog;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="changelog")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AppSoftwareVersionChangelog getChangelog() {
        return this.changelog;
    }

    @JsonProperty(value="changelog")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setChangelog(AppSoftwareVersionChangelog changelog) {
        this.changelog = changelog;
    }

    public AppSoftwareVersionCreateRequest supported(Boolean supported) {
        this.supported = supported;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="States whether the app software version is officially supported.")
    @JsonProperty(value="supported")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getSupported() {
        return this.supported;
    }

    @JsonProperty(value="supported")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupported(Boolean supported) {
        this.supported = supported;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppSoftwareVersionCreateRequest appSoftwareVersionCreateRequest = (AppSoftwareVersionCreateRequest)o;
        return Objects.equals(this.buildNumber, appSoftwareVersionCreateRequest.buildNumber) && Objects.equals(this.versionNumber, appSoftwareVersionCreateRequest.versionNumber) && Objects.equals(this.compatibilities, appSoftwareVersionCreateRequest.compatibilities) && Objects.equals((Object)this.supportedPaymentModel, (Object)appSoftwareVersionCreateRequest.supportedPaymentModel) && Objects.equals(this.frameworkDetails, appSoftwareVersionCreateRequest.frameworkDetails) && Objects.equals(this.licenseType, appSoftwareVersionCreateRequest.licenseType) && Objects.equals(this.sourceCodeLicense, appSoftwareVersionCreateRequest.sourceCodeLicense) && Objects.equals(this.changelog, appSoftwareVersionCreateRequest.changelog) && Objects.equals(this.supported, appSoftwareVersionCreateRequest.supported);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.buildNumber, this.versionNumber, this.compatibilities, this.supportedPaymentModel, this.frameworkDetails, this.licenseType, this.sourceCodeLicense, this.changelog, this.supported});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppSoftwareVersionCreateRequest {\n");
        sb.append("    buildNumber: ").append(this.toIndentedString(this.buildNumber)).append("\n");
        sb.append("    versionNumber: ").append(this.toIndentedString(this.versionNumber)).append("\n");
        sb.append("    compatibilities: ").append(this.toIndentedString(this.compatibilities)).append("\n");
        sb.append("    supportedPaymentModel: ").append(this.toIndentedString((Object)this.supportedPaymentModel)).append("\n");
        sb.append("    frameworkDetails: ").append(this.toIndentedString(this.frameworkDetails)).append("\n");
        sb.append("    licenseType: ").append(this.toIndentedString(this.licenseType)).append("\n");
        sb.append("    sourceCodeLicense: ").append(this.toIndentedString(this.sourceCodeLicense)).append("\n");
        sb.append("    changelog: ").append(this.toIndentedString(this.changelog)).append("\n");
        sb.append("    supported: ").append(this.toIndentedString(this.supported)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SupportedPaymentModelEnum {
        FREE("free"),
        PAIDVIAATLASSIAN("paidViaAtlassian"),
        PAIDVIAVENDOR("paidViaVendor");

        private String value;

        private SupportedPaymentModelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SupportedPaymentModelEnum fromValue(String value) {
            for (SupportedPaymentModelEnum b : SupportedPaymentModelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

