/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.parentsoftware.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Properties related to this parent software's availability for a hosting.")
@JsonPropertyOrder(value={"hosting", "autoCompatibilityMode"})
@JsonTypeName(value="HostingOption")
public class HostingOption {
    public static final String JSON_PROPERTY_HOSTING = "hosting";
    private HostingEnum hosting;
    public static final String JSON_PROPERTY_AUTO_COMPATIBILITY_MODE = "autoCompatibilityMode";
    private AutoCompatibilityModeEnum autoCompatibilityMode;

    public HostingOption hosting(HostingEnum hosting) {
        this.hosting = hosting;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="A hosting type for a software.")
    @JsonProperty(value="hosting")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public HostingEnum getHosting() {
        return this.hosting;
    }

    @JsonProperty(value="hosting")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHosting(HostingEnum hosting) {
        this.hosting = hosting;
    }

    public HostingOption autoCompatibilityMode(AutoCompatibilityModeEnum autoCompatibilityMode) {
        this.autoCompatibilityMode = autoCompatibilityMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies whether app software versions should automatically be marked compatible with new minor version releases, or only new patch version releases.")
    @JsonProperty(value="autoCompatibilityMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AutoCompatibilityModeEnum getAutoCompatibilityMode() {
        return this.autoCompatibilityMode;
    }

    @JsonProperty(value="autoCompatibilityMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAutoCompatibilityMode(AutoCompatibilityModeEnum autoCompatibilityMode) {
        this.autoCompatibilityMode = autoCompatibilityMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostingOption hostingOption = (HostingOption)o;
        return Objects.equals((Object)this.hosting, (Object)hostingOption.hosting) && Objects.equals((Object)this.autoCompatibilityMode, (Object)hostingOption.autoCompatibilityMode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hosting, this.autoCompatibilityMode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HostingOption {\n");
        sb.append("    hosting: ").append(this.toIndentedString((Object)this.hosting)).append("\n");
        sb.append("    autoCompatibilityMode: ").append(this.toIndentedString((Object)this.autoCompatibilityMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum HostingEnum {
        CLOUD("cloud"),
        SERVER("server"),
        DATACENTER("datacenter");

        private String value;

        private HostingEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static HostingEnum fromValue(String value) {
            for (HostingEnum b : HostingEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AutoCompatibilityModeEnum {
        MINOR("minor"),
        PATCH("patch");

        private String value;

        private AutoCompatibilityModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AutoCompatibilityModeEnum fromValue(String value) {
            for (AutoCompatibilityModeEnum b : AutoCompatibilityModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

