/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.parentsoftware.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"buildNumber", "versionNumber", "hosting"})
@JsonTypeName(value="ParentSoftwareVersionCreateRequest")
public class ParentSoftwareVersionCreateRequest {
    public static final String JSON_PROPERTY_BUILD_NUMBER = "buildNumber";
    private Long buildNumber;
    public static final String JSON_PROPERTY_VERSION_NUMBER = "versionNumber";
    private String versionNumber;
    public static final String JSON_PROPERTY_HOSTING = "hosting";
    private List<HostingEnum> hosting = new ArrayList<HostingEnum>();

    public ParentSoftwareVersionCreateRequest buildNumber(Long buildNumber) {
        this.buildNumber = buildNumber;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Build number for the parent software version")
    @JsonProperty(value="buildNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getBuildNumber() {
        return this.buildNumber;
    }

    @JsonProperty(value="buildNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBuildNumber(Long buildNumber) {
        this.buildNumber = buildNumber;
    }

    public ParentSoftwareVersionCreateRequest versionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Version Number of the parent software version")
    @JsonProperty(value="versionNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getVersionNumber() {
        return this.versionNumber;
    }

    @JsonProperty(value="versionNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVersionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
    }

    public ParentSoftwareVersionCreateRequest hosting(List<HostingEnum> hosting) {
        this.hosting = hosting;
        return this;
    }

    public ParentSoftwareVersionCreateRequest addHostingItem(HostingEnum hostingItem) {
        this.hosting.add(hostingItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Hosting types for which this parent software version is available.")
    @JsonProperty(value="hosting")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<HostingEnum> getHosting() {
        return this.hosting;
    }

    @JsonProperty(value="hosting")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHosting(List<HostingEnum> hosting) {
        this.hosting = hosting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParentSoftwareVersionCreateRequest parentSoftwareVersionCreateRequest = (ParentSoftwareVersionCreateRequest)o;
        return Objects.equals(this.buildNumber, parentSoftwareVersionCreateRequest.buildNumber) && Objects.equals(this.versionNumber, parentSoftwareVersionCreateRequest.versionNumber) && Objects.equals(this.hosting, parentSoftwareVersionCreateRequest.hosting);
    }

    public int hashCode() {
        return Objects.hash(this.buildNumber, this.versionNumber, this.hosting);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ParentSoftwareVersionCreateRequest {\n");
        sb.append("    buildNumber: ").append(this.toIndentedString(this.buildNumber)).append("\n");
        sb.append("    versionNumber: ").append(this.toIndentedString(this.versionNumber)).append("\n");
        sb.append("    hosting: ").append(this.toIndentedString(this.hosting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum HostingEnum {
        CLOUD("cloud"),
        SERVER("server"),
        DATACENTER("datacenter");

        private String value;

        private HostingEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static HostingEnum fromValue(String value) {
            for (HostingEnum b : HostingEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

