/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.parentsoftware.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"versionNumber", "hosting", "state", "revision"})
@JsonTypeName(value="ParentSoftwareVersionUpdateRequest")
public class ParentSoftwareVersionUpdateRequest {
    public static final String JSON_PROPERTY_VERSION_NUMBER = "versionNumber";
    private String versionNumber;
    public static final String JSON_PROPERTY_HOSTING = "hosting";
    private List<HostingEnum> hosting = new ArrayList<HostingEnum>();
    public static final String JSON_PROPERTY_STATE = "state";
    private StateEnum state;
    public static final String JSON_PROPERTY_REVISION = "revision";
    private Integer revision;

    public ParentSoftwareVersionUpdateRequest versionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Version Number of the parent software version")
    @JsonProperty(value="versionNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getVersionNumber() {
        return this.versionNumber;
    }

    @JsonProperty(value="versionNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVersionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
    }

    public ParentSoftwareVersionUpdateRequest hosting(List<HostingEnum> hosting) {
        this.hosting = hosting;
        return this;
    }

    public ParentSoftwareVersionUpdateRequest addHostingItem(HostingEnum hostingItem) {
        this.hosting.add(hostingItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Hosting types for which this parent software version is available.")
    @JsonProperty(value="hosting")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<HostingEnum> getHosting() {
        return this.hosting;
    }

    @JsonProperty(value="hosting")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHosting(List<HostingEnum> hosting) {
        this.hosting = hosting;
    }

    public ParentSoftwareVersionUpdateRequest state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="A state in the lifecycle of a software.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StateEnum getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setState(StateEnum state) {
        this.state = state;
    }

    public ParentSoftwareVersionUpdateRequest revision(Integer revision) {
        this.revision = revision;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The revision of parent software version as obtained from GET request.")
    @JsonProperty(value="revision")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getRevision() {
        return this.revision;
    }

    @JsonProperty(value="revision")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRevision(Integer revision) {
        this.revision = revision;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParentSoftwareVersionUpdateRequest parentSoftwareVersionUpdateRequest = (ParentSoftwareVersionUpdateRequest)o;
        return Objects.equals(this.versionNumber, parentSoftwareVersionUpdateRequest.versionNumber) && Objects.equals(this.hosting, parentSoftwareVersionUpdateRequest.hosting) && Objects.equals((Object)this.state, (Object)parentSoftwareVersionUpdateRequest.state) && Objects.equals(this.revision, parentSoftwareVersionUpdateRequest.revision);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.versionNumber, this.hosting, this.state, this.revision});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ParentSoftwareVersionUpdateRequest {\n");
        sb.append("    versionNumber: ").append(this.toIndentedString(this.versionNumber)).append("\n");
        sb.append("    hosting: ").append(this.toIndentedString(this.hosting)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    revision: ").append(this.toIndentedString(this.revision)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        DRAFT("draft"),
        ACTIVE("active"),
        ARCHIVED("archived");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum HostingEnum {
        CLOUD("cloud"),
        SERVER("server"),
        DATACENTER("datacenter");

        private String value;

        private HostingEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static HostingEnum fromValue(String value) {
            for (HostingEnum b : HostingEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

