/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sigillo.signature.verifier;

import com.atlassian.sigillo.signature.verifier.BcCertificateVerifier;
import com.atlassian.sigillo.signature.verifier.CertificateAttributesExtractor;
import com.atlassian.sigillo.signature.verifier.Ed25519PublicKeyParametersAdapter;
import com.atlassian.sigillo.signature.verifier.Verifier;
import com.atlassian.sigillo.signature.verifier.exception.VerifierException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.crypto.signers.Ed25519phSigner;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BcVerifier
implements Verifier {
    private static final Logger logger = LoggerFactory.getLogger(BcVerifier.class);
    private final BcCertificateVerifier certificateVerifier = new BcCertificateVerifier();

    BcVerifier() {
    }

    @Override
    public boolean verifyCertificate(String certificate, List<String> trustedCertificates) {
        return this.certificateVerifier.verifyCertificateLeafAsChain(certificate, trustedCertificates);
    }

    @Override
    public boolean verifyArtifact(InputStream source, String signature, List<String> trustedCertificates) throws VerifierException {
        if (trustedCertificates == null || trustedCertificates.isEmpty()) {
            throw new VerifierException("No trusted certificates provided");
        }
        if (!source.markSupported()) {
            return this.verifyArtifact(new BufferedInputStream(source), signature, trustedCertificates);
        }
        source.mark(Integer.MAX_VALUE);
        byte[] signatureBytes = Base64.decode(BcVerifier.normalizeSignature(signature));
        for (String certificate : trustedCertificates) {
            try {
                int bytesRead;
                source.reset();
                if (!this.certificateVerifier.verifyCertificate(certificate)) continue;
                Ed25519PublicKeyParameters publicKeyParameters = Ed25519PublicKeyParametersAdapter.adapt(new CertificateAttributesExtractor(certificate).getPublicKey());
                Ed25519Signer verifier = new Ed25519Signer();
                verifier.init(false, publicKeyParameters);
                byte[] buffer = new byte[8192];
                while ((bytesRead = source.read(buffer)) != -1) {
                    verifier.update(buffer, 0, bytesRead);
                }
                if (!verifier.verifySignature(signatureBytes)) continue;
                return true;
            }
            catch (Exception e) {
                logger.warn("Error verifying signature: {}", (Object)e.getMessage());
            }
        }
        return false;
    }

    @Override
    public boolean verifyArtifact(InputStream source, String signature, String certificate, List<String> trustedCertificates) throws VerifierException {
        try {
            if (!this.certificateVerifier.verifyCertificateLeafAsChain(certificate, trustedCertificates)) {
                return false;
            }
            byte[] signatureBytes = Base64.decode(BcVerifier.normalizeSignature(signature));
            Ed25519PublicKeyParameters publicKeyParameters = Ed25519PublicKeyParametersAdapter.adapt(new CertificateAttributesExtractor(certificate).getPublicKey());
            Ed25519phSigner verifier = new Ed25519phSigner(new byte[0]);
            verifier.init(false, publicKeyParameters);
            byte[] hashedData = BcVerifier.generateChecksum(source);
            verifier.update(hashedData, 0, hashedData.length);
            return verifier.verifySignature(signatureBytes);
        }
        catch (Exception e) {
            throw new VerifierException("Error verifying signature. " + e.getMessage(), e);
        }
    }

    private static byte[] generateChecksum(InputStream source) throws IOException {
        int bytesRead;
        SHA512Digest digest = new SHA512Digest();
        byte[] buffer = new byte[8192];
        while ((bytesRead = source.read(buffer)) != -1) {
            digest.update(buffer, 0, bytesRead);
        }
        byte[] hashedData = new byte[64];
        digest.doFinal(hashedData, 0);
        return hashedData;
    }

    private static String normalizeSignature(String signature) {
        return signature.replace("-----BEGIN SIGNATURE-----", "").replace("-----END SIGNATURE-----", "").replaceAll("\\s", "");
    }
}

