/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sigillo.signature.verifier;

import com.atlassian.sigillo.signature.verifier.exception.MalformedCertificateException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

final class CertificateAdapter {
    private CertificateAdapter() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static X509Certificate pemToX509Certificate(String certificate) {
        X509Certificate x509Certificate;
        if (certificate == null || certificate.isBlank()) {
            throw new IllegalArgumentException("Certificate data cannot be null or empty");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(certificate.getBytes());
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            x509Certificate = (X509Certificate)cf.generateCertificate(bais);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bais.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | CertificateException e) {
                throw new MalformedCertificateException("Error converting PEM to X509 certificate", e);
            }
        }
        bais.close();
        return x509Certificate;
    }
}

