/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sigillo.signature.verifier;

import com.atlassian.sigillo.signature.verifier.CertificateAdapter;
import com.atlassian.sigillo.signature.verifier.exception.CertificateException;
import com.atlassian.sigillo.signature.verifier.exception.CertificateValidityException;
import com.atlassian.sigillo.signature.verifier.exception.CertificateValidityExceptionType;
import java.io.IOException;
import java.io.StringWriter;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Date;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemWriter;

public class CertificateAttributesExtractor {
    private final X509Certificate x509Certificate;

    public CertificateAttributesExtractor(String certificate) {
        this.x509Certificate = CertificateAdapter.pemToX509Certificate(certificate);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String getPublicKey() throws CertificateException {
        PublicKey publicKey = this.x509Certificate.getPublicKey();
        try (StringWriter stringWriter = new StringWriter();){
            String string;
            try (PemWriter pemWriter = new PemWriter(stringWriter);){
                pemWriter.writeObject(new PemObject("PUBLIC KEY", publicKey.getEncoded()));
                pemWriter.flush();
                string = stringWriter.toString();
            }
            return string;
        }
        catch (IOException e) {
            throw new CertificateException("Cannot extract public key as PEM", e);
        }
    }

    public void checkValidity() {
        Instant date = Instant.now();
        if (this.isBefore(date)) {
            throw new CertificateValidityException(CertificateValidityExceptionType.NOT_YET_VALID, this.x509Certificate.getSubjectX500Principal().getName());
        }
        if (this.isExpired(date)) {
            throw new CertificateValidityException(CertificateValidityExceptionType.EXPIRED, this.x509Certificate.getSubjectX500Principal().getName());
        }
    }

    public boolean isBefore(Instant date) {
        return Date.from(date).before(this.x509Certificate.getNotBefore());
    }

    public boolean isExpired(Instant date) {
        return Date.from(date).after(this.x509Certificate.getNotAfter());
    }

    public String signatureAlgorithm() {
        return this.x509Certificate.getSigAlgName();
    }
}

