/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sigillo.signature.verifier;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Optional;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Ed25519PublicKeyParametersAdapter {
    private static final Logger log = LoggerFactory.getLogger(Ed25519PublicKeyParametersAdapter.class);

    private Ed25519PublicKeyParametersAdapter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static Ed25519PublicKeyParameters adapt(String publicKeyPem) {
        return Optional.ofNullable(Ed25519PublicKeyParametersAdapter.parsePublicKeyQuietly(new ByteArrayInputStream(publicKeyPem.getBytes()))).or(() -> Optional.ofNullable(Ed25519PublicKeyParametersAdapter.readPublicKeyQuietly(new ByteArrayInputStream(publicKeyPem.getBytes())))).orElseThrow(() -> new IllegalArgumentException("Invalid public key, must be an Ed25519 public key"));
    }

    private static Ed25519PublicKeyParameters parsePublicKeyQuietly(InputStream publicKeyStream) {
        try {
            PEMParser pemParser = new PEMParser(new InputStreamReader(publicKeyStream));
            SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfo.getInstance(pemParser.readObject());
            byte[] keyData = publicKeyInfo.getPublicKeyData().getEncoded();
            return new Ed25519PublicKeyParameters(keyData, keyData.length - 32);
        }
        catch (Exception e) {
            log.warn("Error parsing public key. {}", (Object)e.getMessage());
            return null;
        }
    }

    private static Ed25519PublicKeyParameters readPublicKeyQuietly(InputStream publicKeyStream) {
        try {
            PemReader pemReader = new PemReader(new InputStreamReader(publicKeyStream));
            PemObject pemObject = pemReader.readPemObject();
            return new Ed25519PublicKeyParameters(pemObject.getContent());
        }
        catch (Exception e) {
            log.warn("Error reading public key. {}", (Object)e.getMessage());
            return null;
        }
    }
}

