/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm;

import com.atlassian.upm.core.Sys;
import com.atlassian.upm.test.rest.resources.UpmSysResource;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class UpmSys
extends Sys {
    public static final String CHECK_LICENSE_FEATURE_ENABLED = "atlassian.upm.check.license.feature";
    public static final String PURCHASED_ADDONS_FEATURE_ENABLED = "atlassian.upm.purchased.addons.feature";
    public static final String MARKETPLACE_ANALYTICS_USAGE_PATH_PREFIX = "mpac.analytics.usage.path.";
    public static final String DEFAULT_MKT_ANALYTICS_USAGE_PATH_PREFIX = "rest/1.0/plugins/usage/";
    private static final Map<String, String> DEFAULT_MKT_ANALYTICS_PATH = UpmSys.defaultMktAnalyticsPath();

    private static Map<String, String> defaultMktAnalyticsPath() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("vendor-feedback-disable", "/rest/2/analytics/vendor-feedback-disable");
        map.put("vendor-feedback-uninstall", "/rest/2/analytics/vendor-feedback-uninstall");
        map.put("vendor-feedback-unsubscribe", "/rest/2/analytics/vendor-feedback-unsubscribe");
        map.put("updates", "/rest/2/analytics/updates");
        map.put("installed", "/rest/2/analytics/installed");
        map.put("uninstalled", "/rest/2/analytics/uninstalled");
        map.put("plugin-update-request", "/rest/2/analytics/plugin-update-request");
        map.put("enablement-failure", "/rest/2/analytics/enablement-failure");
        map.put("enabled", "/rest/2/analytics/enabled");
        map.put("disabled", "/rest/2/analytics/disabled");
        return map;
    }

    public static String getMpacWebsiteBaseUrl() {
        String ret = System.getProperty("mpac.website");
        if (StringUtils.isBlank(ret)) {
            ret = UpmSys.getMpacBaseUrl();
        }
        return ret.endsWith("/") ? ret.substring(0, ret.length() - 1) : ret;
    }

    public static boolean isPurchasedAddonsEnabled() {
        return UpmSysResource.isPurchasedAddonsFeatureEnabled().orElseGet(() -> Boolean.getBoolean(PURCHASED_ADDONS_FEATURE_ENABLED));
    }

    public static boolean isCheckLicenseFeatureEnabled() {
        return UpmSysResource.isCheckLicenseFeatureEnabled().orElseGet(() -> Boolean.getBoolean(CHECK_LICENSE_FEATURE_ENABLED));
    }

    public static String getMpacAnalyticsPath(String type) {
        return UpmSysResource.getMktAnalyticsPath(type).orElse(System.getProperty(MARKETPLACE_ANALYTICS_USAGE_PATH_PREFIX + type, UpmSys.getMpacDefaultAnalyticsPath(type)));
    }

    public static String getMpacDefaultAnalyticsPath(String type) {
        return DEFAULT_MKT_ANALYTICS_PATH.computeIfAbsent(type, t -> DEFAULT_MKT_ANALYTICS_USAGE_PATH_PREFIX + t);
    }

    public static String getMaxPluginSize() {
        return System.getProperty("atlassian.upm.plugin.maxsize");
    }
}

