/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.api.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public abstract class Option<A>
implements Iterable<A> {
    private static final Option<Object> NONE = new Option<Object>(){

        @Override
        public <B> B fold(Supplier<B> none, Function<Object, B> some) {
            return none.get();
        }
    };

    private Option() {
    }

    public abstract <B> B fold(Supplier<B> var1, Function<A, B> var2);

    public final A get() {
        return this.fold(Option.throwNoSuchElementException(), Function.identity());
    }

    public final <B extends A> A getOrElse(B other) {
        return (A)this.fold(() -> other, Function.identity());
    }

    public final A getOrElse(Supplier<A> supplier) {
        return this.fold(supplier, Function.identity());
    }

    public final boolean isDefined() {
        return this.fold(() -> false, ignored -> true);
    }

    @Override
    @Nonnull
    public final Iterator<A> iterator() {
        return this.fold(Collections::emptyIterator, a -> Collections.singletonList(a).iterator());
    }

    public final Option<A> orElse(Option<A> orElse) {
        return this.orElse(() -> orElse);
    }

    public final Option<A> orElse(Supplier<Option<A>> orElse) {
        return this.fold(orElse, Option::option);
    }

    public final Option<A> filter(Predicate<A> f) {
        return this.flatMap(input -> {
            if (f.test(input)) {
                return Option.some(input);
            }
            return Option.none();
        });
    }

    public final boolean exists(Predicate<A> f) {
        return this.filter(f).isDefined();
    }

    public final <B> Option<B> flatMap(Function<A, Option<B>> f) {
        return this.fold(Option::none, f);
    }

    public final <B> Option<B> map(Function<A, B> f) {
        return this.flatMap(f.andThen(Option::option));
    }

    public final int hashCode() {
        return this.fold(() -> 31, Object::hashCode);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Option other = (Option)obj;
        return other.fold(() -> !this.isDefined(), otherObj -> this.get().equals(otherObj));
    }

    public final String toString() {
        return this.fold(() -> "none()", obj -> String.format("some(%s)", obj));
    }

    public static <A> Option<A> none() {
        return NONE;
    }

    public static <A> Option<A> none(Class<A> type) {
        return NONE;
    }

    public static <A> Option<A> some(A value) {
        return new Some<A>(value);
    }

    public static <A> Option<A> option(A a) {
        if (a == null) {
            return Option.none();
        }
        return Option.some(a);
    }

    private static <A> Supplier<A> throwNoSuchElementException() {
        return () -> {
            throw new NoSuchElementException();
        };
    }

    private static final class Some<A>
    extends Option<A> {
        private final A value;

        private Some(A value) {
            this.value = Objects.requireNonNull(value, "value");
        }

        @Override
        public <B> B fold(Supplier<B> none, Function<A, B> f) {
            return f.apply(this.value);
        }
    }
}

