/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.certificates.rest;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.upm.certificates.rest.CertificateRepresentation;
import com.atlassian.upm.signing.api.Certificate;
import com.atlassian.upm.signing.api.config.UpmConfig;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

@SystemAdminOnly
@Path(value="/certificates")
public class CertificateCollectionResource {
    private final UpmConfig upmConfig;
    private final CertificateFactory certificateFactory;

    @Inject
    public CertificateCollectionResource(UpmConfig upmConfig) throws CertificateException {
        this.upmConfig = Objects.requireNonNull(upmConfig);
        this.certificateFactory = Objects.requireNonNull(CertificateFactory.getInstance("X.509"));
    }

    @GET
    public Response get() throws CertificateException {
        ArrayList<CertificateRepresentation> certificateRepresentations = new ArrayList<CertificateRepresentation>();
        for (Certificate s : this.upmConfig.getCertificates()) {
            CertificateRepresentation certificateRepresentation = this.mapToRepresentation(s);
            certificateRepresentations.add(certificateRepresentation);
        }
        return Response.ok(certificateRepresentations).type("application/vnd.atl.plugins.certificate.collection+json").build();
    }

    private CertificateRepresentation mapToRepresentation(Certificate certificate) throws CertificateException {
        String certifitateContent = certificate.content();
        String filename = certificate.filename();
        certifitateContent = certifitateContent.replace("-----BEGIN CERTIFICATE-----", "");
        certifitateContent = certifitateContent.replace("-----END CERTIFICATE-----", "");
        certifitateContent = certifitateContent.replaceAll("\\s+", "");
        byte[] certificateData = Base64.getDecoder().decode(certifitateContent);
        X509Certificate cert = (X509Certificate)this.certificateFactory.generateCertificate(new ByteArrayInputStream(certificateData));
        return new CertificateRepresentation(filename, CertificateCollectionResource.getSubjectCN(cert.getSubjectX500Principal().getName()), cert.getSubjectX500Principal().getName(), cert.getIssuerX500Principal().getName(), cert.getSerialNumber().toString(), cert.getNotAfter(), (int)((cert.getNotAfter().getTime() - System.currentTimeMillis()) / 86400000L));
    }

    @Nullable
    private static String getSubjectCN(String subject) {
        String subjectCN = null;
        Pattern cnPattern = Pattern.compile("CN=([^,]+)");
        Matcher matcher = cnPattern.matcher(subject);
        if (matcher.find()) {
            subjectCN = matcher.group(1);
        }
        return subjectCN;
    }
}

