/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.install;

import com.atlassian.upm.spi.PluginInstallException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfUpdatePluginExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelfUpdatePluginExtractor.class);
    private static final String SELFUPDATE_PLUGIN_JAR_RESOURCE = "atlassian-universal-plugin-manager-selfupdate-plugin.jar";
    public static final String SELFUPDATE_PLUGIN_NAME = "Atlassian Universal Plugin Manager Self-Update Plugin";

    public static boolean isSelfUpdatePlugin(String name) {
        return SELFUPDATE_PLUGIN_NAME.equals(name);
    }

    public static File extractSelfUpdatePlugin() throws PluginInstallException {
        File file;
        block9: {
            InputStream fromJarStream = SelfUpdatePluginExtractor.class.getClassLoader().getResourceAsStream(SELFUPDATE_PLUGIN_JAR_RESOURCE);
            try {
                File selfUpdateJar = File.createTempFile("upm-selfupdate", ".jar");
                if (fromJarStream == null) {
                    LOGGER.error("Failed to find SelfUpdatePlugin");
                    throw new PluginInstallException("Cannot find SelfUpdatePluginResource atlassian-universal-plugin-manager-selfupdate-plugin.jar");
                }
                Files.copy(fromJarStream, selfUpdateJar.toPath(), StandardCopyOption.REPLACE_EXISTING);
                LOGGER.info("Extracted self-update plugin to " + selfUpdateJar.getAbsolutePath());
                file = selfUpdateJar;
                if (fromJarStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fromJarStream != null) {
                        try {
                            fromJarStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    LOGGER.error("Failed to copy SelfUpdatePlugin", (Throwable)ioe);
                    throw new PluginInstallException("Failed to copy SelfUpdatePlugin", ioe);
                }
            }
            fromJarStream.close();
        }
        return file;
    }
}

