/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.log;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.api.log.AuditLogEntry;
import com.atlassian.upm.core.log.PluginInstallerPluginLogAccessor;
import com.atlassian.upm.core.log.PluginSettingsAuditLogAccessor;
import com.atlassian.upm.core.rest.BaseUriBuilder;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Optional;

public class PluginInstallerPluginLogAccessorImpl
extends PluginSettingsAuditLogAccessor
implements PluginInstallerPluginLogAccessor {
    public static final String KEY_PREFIX = PluginInstallerPluginLogAccessorImpl.class.getName() + ":log:";

    public PluginInstallerPluginLogAccessorImpl(I18nResolver i18nResolver, ApplicationProperties applicationProperties, UserManager userManager, PluginSettingsFactory pluginSettingsFactory, BaseUriBuilder uriBuilder, PluginSettingsAuditLogAccessor.Clock clock) {
        super(i18nResolver, applicationProperties, userManager, pluginSettingsFactory, uriBuilder, clock, KEY_PREFIX);
    }

    public PluginInstallerPluginLogAccessorImpl(I18nResolver i18nResolver, ApplicationProperties applicationProperties, UserManager userManager, PluginSettingsFactory pluginSettingsFactory, BaseUriBuilder uriBuilder) {
        super(i18nResolver, applicationProperties, userManager, pluginSettingsFactory, uriBuilder, KEY_PREFIX);
    }

    @Override
    public Iterable<AuditLogEntry> getLogEntries(Optional<ZonedDateTime> since) {
        return Iterables.filter(super.getLogEntries(), this.since(since.get()));
    }

    private Predicate<AuditLogEntry> since(final ZonedDateTime since) {
        return new Predicate<AuditLogEntry>(){

            public boolean apply(AuditLogEntry entry) {
                return entry.getDate() != null && since.isBefore(entry.getDate().toInstant().atZone(ZoneId.systemDefault()));
            }
        };
    }
}

