/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.pac;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.marketplace.client.MarketplaceClient;
import com.atlassian.marketplace.client.MarketplaceClientFactory;
import com.atlassian.marketplace.client.http.HttpConfiguration;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.upm.LazyReferences;
import com.atlassian.upm.UpmFugueConverters;
import com.atlassian.upm.core.Sys;
import com.atlassian.upm.core.pac.ClientContextFactory;
import com.atlassian.upm.core.pac.MarketplaceBaseUrlChangedEvent;
import com.atlassian.upm.core.pac.MarketplaceClientConfiguration;
import com.atlassian.upm.core.pac.MarketplaceClientManager;
import com.atlassian.upm.core.pac.PacRequestHeaderProvider;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.net.URI;
import java.util.Dictionary;
import java.util.Objects;
import org.osgi.framework.BundleContext;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractMarketplaceClientManager
implements DisposableBean,
InitializingBean,
MarketplaceClientManager {
    private final ApplicationProperties applicationProperties;
    private final ResettableLazyReference<MarketplaceClient> client;
    private final EventPublisher eventPublisher;
    private final String version;

    public AbstractMarketplaceClientManager(ApplicationProperties applicationProperties, final ClientContextFactory clientContextFactory, BundleContext bundleContext, EventPublisher eventPublisher) {
        this.applicationProperties = Objects.requireNonNull(applicationProperties, "applicationProperties");
        Objects.requireNonNull(clientContextFactory, "clientContextFactory");
        this.client = new ResettableLazyReference<MarketplaceClient>(){

            protected MarketplaceClient create() {
                PacRequestHeaderProvider rd = new PacRequestHeaderProvider(clientContextFactory, AbstractMarketplaceClientManager.this.getRequestOrigin(), AbstractMarketplaceClientManager.this.getUserAgent());
                HttpConfiguration httpConfig = MarketplaceClientConfiguration.httpConfigurationFromSystemProperties().requestDecorator(UpmFugueConverters.fugueSome(rd)).build();
                return MarketplaceClientFactory.createMarketplaceClient(URI.create(Sys.getMpacBaseUrl()), httpConfig);
            }
        };
        this.eventPublisher = Objects.requireNonNull(eventPublisher, "eventPublisher");
        Dictionary headers = bundleContext.getBundle().getHeaders();
        this.version = headers.get("Bundle-Version").toString();
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    @Override
    public MarketplaceClient getMarketplaceClient() {
        return LazyReferences.safeGet(this.client);
    }

    @EventListener
    public void changedMpacBaseUrl(MarketplaceBaseUrlChangedEvent event) {
        if (this.client.isInitialized()) {
            ((MarketplaceClient)this.client.get()).close();
            this.client.reset();
        }
    }

    public void destroy() {
        if (this.client.isInitialized()) {
            ((MarketplaceClient)this.client.get()).close();
        }
        this.eventPublisher.unregister((Object)this);
    }

    private String getRequestOrigin() {
        String baseUrl = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
        int p = baseUrl.indexOf(47, baseUrl.indexOf("//") + 2);
        return p < 0 ? baseUrl : baseUrl.substring(0, p);
    }

    public abstract String getUserAgentPrefix();

    @Override
    public String getUserAgent() {
        return System.getProperty("http.pac.userAgent", this.getUserAgentPrefix() + this.getVersion());
    }

    protected String getVersion() {
        return this.version;
    }
}

