/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.pac;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.marketplace.parentsoftware.client.ParentSoftwareClient;
import com.atlassian.marketplace.parentsoftware.client.ParentSoftwareClientFactory;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.upm.LazyReferences;
import com.atlassian.upm.core.Sys;
import com.atlassian.upm.core.pac.ClientContextFactory;
import com.atlassian.upm.core.pac.MarketplaceBaseUrlChangedEvent;
import com.atlassian.upm.core.pac.PacRequestHeaderProvider;
import com.atlassian.upm.core.pac.ParentSoftwareClientConfiguration;
import com.atlassian.upm.core.pac.ParentSoftwareClientManager;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.net.URI;
import java.util.Dictionary;
import java.util.Objects;
import java.util.Optional;
import org.osgi.framework.BundleContext;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractParentSoftwareClientManager
implements DisposableBean,
InitializingBean,
ParentSoftwareClientManager {
    private final ApplicationProperties applicationProperties;
    private final ResettableLazyReference<ParentSoftwareClient> client;
    private final EventPublisher eventPublisher;
    private final String version;

    public AbstractParentSoftwareClientManager(ApplicationProperties applicationProperties, final ClientContextFactory clientContextFactory, BundleContext bundleContext, EventPublisher eventPublisher) {
        this.applicationProperties = Objects.requireNonNull(applicationProperties, "applicationProperties");
        Objects.requireNonNull(clientContextFactory, "clientContextFactory");
        this.client = new ResettableLazyReference<ParentSoftwareClient>(){

            protected ParentSoftwareClient create() {
                PacRequestHeaderProvider pacRequestHeaderProvider = new PacRequestHeaderProvider(clientContextFactory, AbstractParentSoftwareClientManager.this.getRequestOrigin(), AbstractParentSoftwareClientManager.this.getUserAgent());
                return ParentSoftwareClientFactory.createParentsSoftwareClient(URI.create(Sys.getParentSoftwareApiBaseUrl()), ParentSoftwareClientConfiguration.httpConfigurationFromSystemProperties().headers(Optional.of(pacRequestHeaderProvider)).build(), Sys.isDevModeEnabled());
            }
        };
        this.eventPublisher = Objects.requireNonNull(eventPublisher, "eventPublisher");
        Dictionary headers = bundleContext.getBundle().getHeaders();
        this.version = headers.get("Bundle-Version").toString();
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    @Override
    public ParentSoftwareClient getParentSoftwareClient() {
        return LazyReferences.safeGet(this.client);
    }

    @EventListener
    public void changedMpacBaseUrl(MarketplaceBaseUrlChangedEvent event) {
        if (this.client.isInitialized()) {
            this.client.reset();
        }
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    private String getRequestOrigin() {
        String baseUrl = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
        int p = baseUrl.indexOf(47, baseUrl.indexOf("//") + 2);
        return p < 0 ? baseUrl : baseUrl.substring(0, p);
    }

    public abstract String getUserAgentPrefix();

    @Override
    public String getUserAgent() {
        return System.getProperty("http.pac.userAgent", this.getUserAgentPrefix() + this.getVersion());
    }

    protected String getVersion() {
        return this.version;
    }
}

