/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.pac;

import com.atlassian.marketplace.client.http.HttpConfiguration;
import com.atlassian.marketplace.parentsoftware.http.HttpConfiguration;
import com.atlassian.upm.core.pac.MarketplaceClientConfiguration;

public class ParentSoftwareClientConfiguration {
    public static HttpConfiguration.Builder httpConfigurationFromSystemProperties() {
        com.atlassian.marketplace.client.http.HttpConfiguration legacyConfig = MarketplaceClientConfiguration.httpConfigurationFromSystemProperties().build();
        HttpConfiguration.Builder builder = HttpConfiguration.builder().connectTimeoutMillis(legacyConfig.getConnectTimeoutMillis()).readTimeoutMillis(legacyConfig.getReadTimeoutMillis());
        for (HttpConfiguration.ProxyConfiguration legacyProxyConfig : legacyConfig.getProxyConfiguration()) {
            builder.proxyConfiguration(ParentSoftwareClientConfiguration.mapProxyConfig(legacyProxyConfig));
        }
        return builder;
    }

    private static HttpConfiguration.ProxyConfiguration mapProxyConfig(HttpConfiguration.ProxyConfiguration legacyProxyConfig) {
        HttpConfiguration.ProxyConfiguration.Builder proxy = HttpConfiguration.ProxyConfiguration.builder();
        for (HttpConfiguration.ProxyHost legacyHost : legacyProxyConfig.getProxyHost()) {
            proxy.proxyHost(ParentSoftwareClientConfiguration.mapProxyHost(legacyHost));
        }
        for (HttpConfiguration.ProxyAuthParams legacyAuthParams : legacyProxyConfig.getAuthParams()) {
            proxy.authParams(ParentSoftwareClientConfiguration.mapAuthParams(legacyAuthParams));
        }
        return proxy.build();
    }

    private static HttpConfiguration.ProxyAuthParams mapAuthParams(HttpConfiguration.ProxyAuthParams legacyAuthParams) {
        HttpConfiguration.Credentials credentials = ParentSoftwareClientConfiguration.mapCredentials(legacyAuthParams.getCredentials());
        HttpConfiguration.ProxyAuthMethod method = HttpConfiguration.ProxyAuthMethod.fromKey(legacyAuthParams.getAuthMethod().name()).orElse(HttpConfiguration.ProxyAuthMethod.BASIC);
        return new HttpConfiguration.ProxyAuthParams(credentials, method, (String)legacyAuthParams.getNtlmDomain().getOr(() -> null), (String)legacyAuthParams.getNtlmWorkstation().getOr(() -> null));
    }

    private static HttpConfiguration.Credentials mapCredentials(HttpConfiguration.Credentials credentials) {
        return new HttpConfiguration.Credentials(credentials.getUsername(), credentials.getPassword());
    }

    private static HttpConfiguration.ProxyHost mapProxyHost(HttpConfiguration.ProxyHost legacyHost) {
        return new HttpConfiguration.ProxyHost(legacyHost.getHostname(), legacyHost.getPort());
    }
}

