/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.rest.representations;

import com.atlassian.upm.core.rest.async.LegacyAsyncTaskRepresentation;
import com.atlassian.upm.core.rest.representations.BaseRepresentationFactory;
import com.atlassian.upm.core.rest.representations.ErrorRepresentation;
import com.atlassian.upm.core.rest.representations.JsonProvider;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Objects;

@Provider
@Produces(value={"text/html"})
@Priority(value=3999)
public class HtmlWrappedJsonProvider
implements MessageBodyWriter<Object> {
    private final JsonProvider jsonProvider;

    @Inject
    public HtmlWrappedJsonProvider(BaseRepresentationFactory representationFactory) {
        this.jsonProvider = new JsonProvider(Objects.requireNonNull(representationFactory, "representationFactory"));
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return LegacyAsyncTaskRepresentation.class.isAssignableFrom(type) || ErrorRepresentation.class.isAssignableFrom(type);
    }

    public void writeTo(Object value, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        OutputStreamWriter writer = new OutputStreamWriter(entityStream);
        writer.write("<textarea>");
        ((Writer)writer).flush();
        this.jsonProvider.writeTo(value, type, genericType, annotations, MediaType.APPLICATION_JSON_TYPE, httpHeaders, entityStream);
        writer.write("</textarea>");
        ((Writer)writer).flush();
    }
}

