/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.rest.resources;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.plugins.rest.api.multipart.FilePart;
import com.atlassian.plugins.rest.api.multipart.MultipartFormParam;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoNotRequired;
import com.atlassian.upm.Iterables;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.core.ApplicationPluginsManager;
import com.atlassian.upm.core.Plugin;
import com.atlassian.upm.core.PluginDownloadService;
import com.atlassian.upm.core.PluginInstallationService;
import com.atlassian.upm.core.PluginOrigin;
import com.atlassian.upm.core.PluginRetriever;
import com.atlassian.upm.core.PluginSignatureReader;
import com.atlassian.upm.core.Plugins;
import com.atlassian.upm.core.SelfUpdateController;
import com.atlassian.upm.core.async.AsyncTaskInfo;
import com.atlassian.upm.core.async.AsynchronousTaskManager;
import com.atlassian.upm.core.impl.UpmAppManager;
import com.atlassian.upm.core.log.AuditLogService;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.policy.PolicyEnforcer;
import com.atlassian.upm.core.policy.PolicyException;
import com.atlassian.upm.core.rest.BaseUriBuilder;
import com.atlassian.upm.core.rest.async.AsyncTaskRepresentationFactory;
import com.atlassian.upm.core.rest.representations.BasePluginRepresentationFactory;
import com.atlassian.upm.core.rest.resources.RequestContext;
import com.atlassian.upm.core.rest.resources.UpmResources;
import com.atlassian.upm.core.rest.resources.install.DownloadingInstallTask;
import com.atlassian.upm.core.rest.resources.install.InstallFromFileUploadTask;
import com.atlassian.upm.core.rest.resources.install.InstallFromMarketplaceTask;
import com.atlassian.upm.core.rest.resources.install.InstallFromUriTask;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.core.token.TokenManager;
import com.atlassian.upm.core.util.PluginTempFileManager;
import com.atlassian.upm.signing.api.PluginSignature;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOUtils;

@Path(value="/")
public class PluginCollectionResource {
    private final BasePluginRepresentationFactory representationFactory;
    private final PluginDownloadService pluginDownloadService;
    private final PluginInstallationService pluginInstaller;
    private final PluginSignatureReader pluginSignatureReader;
    private final SelfUpdateController selfUpdateController;
    private final AsynchronousTaskManager taskManager;
    private final PermissionEnforcer permissionEnforcer;
    private final AuditLogService auditLogger;
    private final TokenManager tokenManager;
    private final UserManager userManager;
    private final BaseUriBuilder uriBuilder;
    private final PluginRetriever pluginRetriever;
    private final LocaleResolver localeResolver;
    private final I18nResolver i18nResolver;
    private final AsyncTaskRepresentationFactory taskRepresentationFactory;
    private final ApplicationPluginsManager applicationPluginsManager;
    private final PolicyEnforcer policyEnforcer;
    private final PluginTempFileManager pluginTempFileManager;

    @Inject
    public PluginCollectionResource(BasePluginRepresentationFactory representationFactory, PluginDownloadService pluginDownloadService, PluginInstallationService pluginInstaller, PluginSignatureReader pluginSignatureReader, SelfUpdateController selfUpdateController, AsynchronousTaskManager taskManager, PermissionEnforcer permissionEnforcer, AuditLogService auditLogger, TokenManager tokenManager, UserManager userManager, BaseUriBuilder uriBuilder, PluginRetriever pluginRetriever, LocaleResolver localeResolver, I18nResolver i18nResolver, AsyncTaskRepresentationFactory taskRepresentationFactory, ApplicationPluginsManager applicationPluginsManager, PolicyEnforcer policyEnforcer, PluginTempFileManager pluginTempFileManager) {
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer, "permissionEnforcer");
        this.representationFactory = Objects.requireNonNull(representationFactory, "representationFactory");
        this.pluginDownloadService = Objects.requireNonNull(pluginDownloadService, "pluginDownloadService");
        this.pluginInstaller = Objects.requireNonNull(pluginInstaller, "pluginInstaller");
        this.pluginSignatureReader = Objects.requireNonNull(pluginSignatureReader, "pluginSignatureReader");
        this.selfUpdateController = Objects.requireNonNull(selfUpdateController, "selfUpdateController");
        this.taskManager = Objects.requireNonNull(taskManager, "taskManager");
        this.auditLogger = Objects.requireNonNull(auditLogger, "auditLogger");
        this.tokenManager = Objects.requireNonNull(tokenManager, "tokenManager");
        this.userManager = Objects.requireNonNull(userManager, "userManager");
        this.uriBuilder = Objects.requireNonNull(uriBuilder, "uriBuilder");
        this.pluginRetriever = Objects.requireNonNull(pluginRetriever, "pluginRetriever");
        this.localeResolver = Objects.requireNonNull(localeResolver, "localeResolver");
        this.i18nResolver = Objects.requireNonNull(i18nResolver, "i18nResolver");
        this.taskRepresentationFactory = Objects.requireNonNull(taskRepresentationFactory, "taskRepresentationFactory");
        this.applicationPluginsManager = Objects.requireNonNull(applicationPluginsManager, "applicationPluginsManager");
        this.policyEnforcer = Objects.requireNonNull(policyEnforcer, "policyEnforcer");
        this.pluginTempFileManager = Objects.requireNonNull(pluginTempFileManager, "pluginTempFileManager");
    }

    @GET
    @AdminOnly
    @Produces(value={"application/vnd.atl.plugins.installed+json"})
    public Response get(@Context HttpServletRequest request) {
        this.permissionEnforcer.enforcePermission(Permission.GET_INSTALLED_PLUGINS);
        List<Plugin> plugins = Iterables.toList(this.pluginRetriever.getPlugins());
        Map<String, UpmAppManager.ApplicationDescriptorModuleInfo> appPlugins = this.applicationPluginsManager.getApplicationRelatedPlugins(StreamSupport.stream(plugins.spliterator(), false).map(Plugins.toPlugPlugin).collect(Collectors.toList()));
        return Response.ok((Object)this.representationFactory.createInstalledPluginCollectionRepresentation(this.localeResolver.getLocale(request), plugins, appPlugins, new RequestContext(request))).header("upm-token", (Object)this.tokenManager.getTokenForUser(this.userManager.getRemoteUserKey())).build();
    }

    @HEAD
    @Produces(value={"application/vnd.atl.plugins.installed+json"})
    @WebSudoNotRequired
    public Response head() {
        this.permissionEnforcer.enforceAdmin();
        return Response.ok().header("upm-token", (Object)this.tokenManager.getTokenForUser(this.userManager.getRemoteUserKey())).build();
    }

    @POST
    @AdminOnly
    @Consumes(value={"application/vnd.atl.plugins.install.uri+json"})
    public Response installFromUri(InstallPluginUri installPluginUri, @QueryParam(value="token") String token) {
        try {
            URI uri = new URI(installPluginUri.getPluginUri());
            PluginOrigin pluginOrigin = PluginOrigin.find(installPluginUri.getPluginOrigin());
            String name = installPluginUri.getPluginName();
            this.permissionEnforcer.enforceAdmin();
            this.policyEnforcer.checkCanInstallPluginFromUri(uri);
            pluginOrigin = this.policyEnforcer.resolvePluginOriginMatchingUri(uri, pluginOrigin);
            UpmResources.validateToken(token, this.userManager.getRemoteUserKey(), "application/json", this.tokenManager, this.representationFactory);
            if (!uri.isAbsolute()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.representationFactory.createI18nErrorRepresentation("upm.pluginInstall.error.invalid.relative.uri")).type("application/vnd.atl.plugins.task.error+json").build();
            }
            DownloadingInstallTask task = switch (pluginOrigin) {
                case PluginOrigin.UPLOAD -> new InstallFromUriTask(uri, this.pluginSignatureReader.decode(installPluginUri.getSignature()), Option.option(name), this.pluginDownloadService, this.auditLogger, this.pluginInstaller, this.selfUpdateController, this.uriBuilder, this.applicationPluginsManager, this.i18nResolver, this.permissionEnforcer);
                case PluginOrigin.MARKETPLACE -> new InstallFromMarketplaceTask(uri, Option.option(name), this.pluginDownloadService, this.auditLogger, this.pluginInstaller, this.selfUpdateController, this.uriBuilder, this.applicationPluginsManager, this.i18nResolver, this.permissionEnforcer);
                default -> throw new PolicyException("Invalid Plugin Origin");
            };
            AsyncTaskInfo taskInfo = this.taskManager.executeAsynchronousTask(task);
            return this.taskRepresentationFactory.createLegacyAsyncTaskRepresentation(taskInfo).toNewlyCreatedResponse(this.uriBuilder);
        }
        catch (URISyntaxException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.representationFactory.createI18nErrorRepresentation("upm.pluginInstall.error.invalid.uri.syntax")).type("application/vnd.atl.plugins.task.error+json").build();
        }
    }

    @SystemAdminOnly
    @POST
    @Consumes(value={"multipart/form-data", "multipart/mixed"})
    @XsrfProtectionExcluded
    public Response installFromFileSystem(@Context HttpServletRequest request, @MultipartFormParam(value="plugin") FilePart pluginPart, @MultipartFormParam(value="signature") FilePart signaturePart, @DefaultValue(value="jar") @QueryParam(value="type") String type, @QueryParam(value="token") String token) {
        this.permissionEnforcer.enforcePermission(Permission.MANAGE_IN_PROCESS_PLUGIN_INSTALL_FROM_FILE);
        this.policyEnforcer.checkCanInstallPluginByUpload();
        UpmResources.validateToken(token, this.userManager.getRemoteUserKey(), "text/html", this.tokenManager, this.representationFactory);
        try {
            PluginSignature signature = signaturePart == null ? null : this.pluginSignatureReader.readSignature(PluginCollectionResource.copyFilePartToString(signaturePart.getInputStream()));
            InstallFromFileUploadTask task = new InstallFromFileUploadTask(pluginPart, type, signature, this.pluginInstaller, this.selfUpdateController, this.uriBuilder, this.applicationPluginsManager, this.i18nResolver, this.pluginTempFileManager, this.permissionEnforcer, this.auditLogger);
            AsyncTaskInfo taskInfo = this.taskManager.executeAsynchronousTask(task);
            Response response = this.taskRepresentationFactory.createLegacyAsyncTaskRepresentation(taskInfo).toNewlyCreatedResponse(this.uriBuilder);
            String acceptHeader = request.getHeader("Accept");
            if (acceptHeader != null && (acceptHeader.contains("text/html") || acceptHeader.contains("*"))) {
                return Response.fromResponse((Response)response).type("text/html").build();
            }
            return response;
        }
        catch (IOException e) {
            return Response.serverError().entity((Object)this.representationFactory.createErrorRepresentation(e.getMessage())).type("application/vnd.atl.plugins.error+json").build();
        }
    }

    private static String copyFilePartToString(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)baos);
        return baos.toString(StandardCharsets.UTF_8);
    }

    public static class InstallPluginUri {
        @JsonProperty
        private String pluginUri;
        @JsonProperty
        private PluginSignature signature;
        @JsonProperty
        private String pluginName;
        @JsonProperty
        private String pluginOrigin;

        @JsonCreator
        public InstallPluginUri(@JsonProperty(value="pluginUri") String pluginUri, @JsonProperty(value="signature") PluginSignature signature, @JsonProperty(value="pluginName") String pluginName, @JsonProperty(value="pluginSource") String pluginOrigin) {
            this.pluginUri = pluginUri;
            this.signature = signature;
            this.pluginName = pluginName;
            this.pluginOrigin = pluginOrigin;
        }

        public String getPluginOrigin() {
            return this.pluginOrigin;
        }

        public String getPluginUri() {
            return this.pluginUri;
        }

        public String getPluginName() {
            return this.pluginName;
        }

        public PluginSignature getSignature() {
            return this.signature;
        }
    }
}

