/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.rest.resources.install;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.core.ApplicationPluginsManager;
import com.atlassian.upm.core.PluginDownloadService;
import com.atlassian.upm.core.PluginInstallationService;
import com.atlassian.upm.core.PluginOrigin;
import com.atlassian.upm.core.SelfUpdateController;
import com.atlassian.upm.core.async.AsyncTaskStatus;
import com.atlassian.upm.core.async.AsyncTaskStatusUpdater;
import com.atlassian.upm.core.log.AuditLogService;
import com.atlassian.upm.core.rest.BaseUriBuilder;
import com.atlassian.upm.core.rest.resources.install.DownloadingInstallTask;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.signing.api.PluginSignature;
import java.io.File;
import java.net.URI;
import java.util.function.Function;

public class InstallFromUriTask
extends DownloadingInstallTask {
    private final PermissionEnforcer permissionEnforcer;
    private final PluginSignature pluginSignature;

    public InstallFromUriTask(URI uri, PluginSignature signature, Option<String> name, PluginDownloadService downloader, AuditLogService auditLogger, PluginInstallationService pluginInstaller, SelfUpdateController selfUpdateController, BaseUriBuilder uriBuilder, ApplicationPluginsManager applicationPluginsManager, I18nResolver i18nResolver, PermissionEnforcer permissionEnforcer) {
        super(uri, Option.option(uri.toASCIIString()), name, pluginInstaller, selfUpdateController, auditLogger, downloader, uriBuilder, applicationPluginsManager, i18nResolver);
        this.permissionEnforcer = permissionEnforcer;
        this.pluginSignature = signature;
    }

    @Override
    protected AsyncTaskStatus executeTask(AsyncTaskStatusUpdater statusUpdater) throws Exception {
        return this.download(statusUpdater).fold(Function.identity(), downloaded -> {
            File pluginFile = downloaded.getFile();
            String name = downloaded.getName();
            Option<String> contentType = downloaded.getContentType();
            this.permissionEnforcer.enforceInProcessInstallationFromUriPermission(this.getUri());
            PluginSignature signature = this.pluginSignature;
            if (signature == null || signature.isEmpty() && downloaded.getSignature() != null) {
                signature = downloaded.getSignature();
            }
            return this.installFromFile(pluginFile, signature, name, contentType, this.installingStatus(this.getName(name)), statusUpdater);
        });
    }

    @Override
    protected PluginOrigin getPluginOrigin() {
        return PluginOrigin.UPLOAD;
    }
}

