/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.test.rest.resources;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.core.Sys;
import com.atlassian.upm.core.pac.PlatformBuildNumberChangeEvent;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Iterator;
import java.util.Objects;

@SystemAdminOnly
@Path(value="/build-number")
public class BuildNumberResource {
    private final EventPublisher eventPublisher;
    private final PermissionEnforcer permissionEnforcer;
    private static Option<BuildNumberRepresentation> buildNumber = Option.none();

    @Inject
    public BuildNumberResource(EventPublisher eventPublisher, PermissionEnforcer permissionEnforcer) {
        this.eventPublisher = Objects.requireNonNull(eventPublisher, "eventPublisher");
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer, "permissionEnforcer");
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins.build.number+json"})
    public Response getBuildNumberResource() {
        this.permissionEnforcer.enforcePermission(Permission.GET_AUDIT_LOG);
        if (!Sys.isUpmDebugModeEnabled()) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        return this.response();
    }

    @PUT
    @Consumes(value={"application/vnd.atl.plugins.build.number+json"})
    public Response setBuildNumber(BuildNumberRepresentation buildNumberRepresentation) {
        this.permissionEnforcer.enforceSystemAdmin();
        if (!Sys.isUpmDebugModeEnabled()) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        BuildNumberResource.setBuildNumberOverride(Option.some(buildNumberRepresentation));
        this.eventPublisher.publish((Object)new PlatformBuildNumberChangeEvent());
        return this.response();
    }

    @DELETE
    public Response clearBuildNumber() {
        this.permissionEnforcer.enforceSystemAdmin();
        if (!Sys.isUpmDebugModeEnabled()) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        BuildNumberResource.setBuildNumberOverride(Option.none(BuildNumberRepresentation.class));
        this.eventPublisher.publish((Object)new PlatformBuildNumberChangeEvent());
        return this.response();
    }

    private Response response() {
        return Response.ok((Object)buildNumber.getOrElse((BuildNumberRepresentation)null)).type("application/vnd.atl.plugins.build.number+json").build();
    }

    public static void setBuildNumberOverride(Option<BuildNumberRepresentation> rep) {
        buildNumber = rep;
    }

    public static Option<String> getBuildNumber() {
        Iterator<BuildNumberRepresentation> iterator = buildNumber.iterator();
        if (iterator.hasNext()) {
            BuildNumberRepresentation rep = iterator.next();
            return Option.option(rep.getBuildNumber());
        }
        return Option.none();
    }

    public static Option<Boolean> isDevelopment() {
        Iterator<BuildNumberRepresentation> iterator = buildNumber.iterator();
        if (iterator.hasNext()) {
            BuildNumberRepresentation rep = iterator.next();
            return Option.option(rep.isDevelopment());
        }
        return Option.none();
    }

    public static final class BuildNumberRepresentation {
        @JsonProperty
        private String buildNumber;
        @JsonProperty
        private Boolean development;

        @JsonCreator
        public BuildNumberRepresentation(@JsonProperty(value="build-number") String buildNumber, @JsonProperty(value="development") Boolean development) {
            this.buildNumber = buildNumber;
            this.development = development;
        }

        public String getBuildNumber() {
            return this.buildNumber;
        }

        public boolean isDevelopment() {
            return this.development;
        }
    }
}

