/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.test.rest.resources;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.upm.core.Sys;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

@SystemAdminOnly
@Path(value="/sys")
public class SysResource {
    private final PermissionEnforcer permissionEnforcer;
    private static Optional<SysUpdateValueRepresentation> isDevMode = Optional.empty();

    @Inject
    public SysResource(PermissionEnforcer permissionEnforcer) {
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer, "permissionEnforcer");
    }

    private Response getBooleanResponse(Optional<SysUpdateValueRepresentation> rep) {
        return this.checkPermission().or(() -> rep.map(value -> Response.ok((Object)value).build())).orElseGet(() -> Response.status((Response.Status)Response.Status.NOT_FOUND).build());
    }

    private Optional<Response> checkPermission() {
        this.permissionEnforcer.enforceSystemAdmin();
        if (!Sys.isUpmDebugModeEnabled()) {
            return Optional.of(Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build());
        }
        return Optional.empty();
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins+json"})
    @Path(value="dev-mode")
    public Response getDevMode() {
        return this.getBooleanResponse(isDevMode);
    }

    @PUT
    @Consumes(value={"application/vnd.atl.plugins+json"})
    @Path(value="dev-mode")
    public Response setIsDevMode(SysUpdateValueRepresentation rep) throws Exception {
        return this.checkPermission().orElseGet(() -> this.setValue(rep, v -> {
            isDevMode = v;
        }));
    }

    private Response setValue(SysUpdateValueRepresentation rep, Consumer<Optional<SysUpdateValueRepresentation>> setter) {
        setter.accept(Optional.of(rep));
        return Response.ok((Object)rep).type("application/vnd.atl.plugins+json").build();
    }

    private Response resetValue(Consumer<Optional<SysUpdateValueRepresentation>> setter) {
        setter.accept(Optional.empty());
        return Response.ok().build();
    }

    @DELETE
    @Path(value="dev-mode")
    public Response resetIsDevMode() {
        return this.checkPermission().orElseGet(() -> this.resetValue(x -> {
            isDevMode = x;
        }));
    }

    public static Optional<Boolean> getIsDevMode() {
        return isDevMode.map(SysUpdateValueRepresentation::getValue);
    }

    public static final class SysUpdateValueRepresentation {
        @JsonProperty
        private Boolean value;

        @JsonCreator
        public SysUpdateValueRepresentation(@JsonProperty(value="value") Boolean value) {
            this.value = value;
        }

        public Boolean getValue() {
            return this.value;
        }
    }

    public static final class SysUpdateStringValueRepresentation {
        @JsonProperty
        private String value;

        @JsonCreator
        public SysUpdateStringValueRepresentation(@JsonProperty(value="value") String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

