/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.jwt;

import com.atlassian.jwt.SigningAlgorithm;
import com.atlassian.jwt.core.writer.JsonSmartJwtJsonBuilder;
import com.atlassian.jwt.core.writer.NimbusJwtWriterFactory;
import com.atlassian.jwt.writer.JwtJsonBuilder;
import com.atlassian.jwt.writer.JwtWriterFactory;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.jwt.JwtTokenFactory;
import com.atlassian.upm.jwt.UpmJwtToken;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;

public class JwtTokenFactoryImpl
implements JwtTokenFactory {
    private JwtWriterFactory jwtWriterFactory;
    private final ObjectMapper mapper;

    JwtTokenFactoryImpl(JwtWriterFactory jwtWriterFactory, ObjectMapper mapper) {
        this.jwtWriterFactory = Objects.requireNonNull(jwtWriterFactory);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public JwtTokenFactoryImpl() {
        this(new NimbusJwtWriterFactory(), new MappingJsonFactory().getCodec());
    }

    @Override
    public UpmJwtToken generateToken(String sharedSecret, Map<String, String> claims, Option<? extends Object> postBody) {
        Instant now = Instant.now();
        long issuedAt = now.toEpochMilli();
        long expiresAt = now.plus(Duration.ofMinutes(3L)).toEpochMilli();
        String key = "atlassian-universal-plugin-manager-plugin";
        JwtJsonBuilder jwtBuilder = new JsonSmartJwtJsonBuilder().issuedAt(issuedAt).expirationTime(expiresAt).issuer(key);
        Map<String, String> allClaims = this.conditionallyAddPostBodyHashClaim(claims, postBody);
        for (String claimKey : allClaims.keySet()) {
            jwtBuilder.claim(claimKey, allClaims.get(claimKey));
        }
        return new UpmJwtToken(this.jwtWriterFactory.macSigningWriter(SigningAlgorithm.HS256, sharedSecret).jsonToJwt(jwtBuilder.build()));
    }

    private Map<String, String> conditionallyAddPostBodyHashClaim(Map<String, String> claims, Option<? extends Object> postBody) {
        Iterator<? extends Object> iterator = postBody.iterator();
        if (iterator.hasNext()) {
            Object pb = iterator.next();
            HashMap<String, String> allClaims = new HashMap<String, String>(claims);
            try {
                allClaims.put("rbSha", DigestUtils.shaHex((String)this.mapper.writeValueAsString(pb)));
            }
            catch (IOException e) {
                throw new RuntimeException("Could not serialize post body", e);
            }
            return Collections.unmodifiableMap(allClaims);
        }
        return claims;
    }
}

