/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license;

import com.atlassian.plugin.PluginInformation;
import com.atlassian.upm.api.license.HostLicenseInformation;
import com.atlassian.upm.api.license.entity.LicenseEditionType;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.license.LicensedAttributes;
import java.time.Duration;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.function.Predicate;

public class PluginLicenses {
    private static final Function<PluginLicense, String> licensePluginKey = PluginLicense::getPluginKey;
    private static final Function<PluginLicense, ZonedDateTime> licenseCreationDate = PluginLicense::getCreationZonedDate;
    public static Function<PluginLicense, Boolean> getLicenseAutoRenewal = PluginLicense::isAutoRenewal;
    public static Function<PluginLicense, Option<Integer>> getLicenseEdition = PluginLicense::getEdition;
    public static Function<PluginLicense, LicenseEditionType> getLicenseEditionType = PluginLicense::getEditionType;

    public static Predicate<PluginLicense> hasError(LicenseError error) {
        return license -> error == license.getError().getOrElse((LicenseError)null);
    }

    public static Predicate<PluginLicense> isNearlyExpired() {
        return license -> LicensedAttributes.isNearlyExpired().test(LicensedAttributes.LicenseAttributes.from(license));
    }

    public static Predicate<PluginLicense> isNearlyMaintenanceExpired() {
        return license -> LicensedAttributes.isNearlyMaintenanceExpired().test(LicensedAttributes.LicenseAttributes.from(license));
    }

    public static boolean isRoleNearlyExceeded(Option<PluginLicense> pluginLicense, Option<Integer> currentRoleCount) {
        return LicensedAttributes.isRoleNearlyExceeded(LicensedAttributes.LicenseAttributes.from(pluginLicense), currentRoleCount);
    }

    public static Predicate<PluginLicense> isRecentlyExpired() {
        return new IsRecentlyExpired(Duration.ofDays(LicensedAttributes.RECENTLY_EXPIRED_DAYS.intValue()));
    }

    public static Predicate<PluginLicense> isRecentlyMaintenanceExpired() {
        return new IsRecentlyMaintenanceExpired(Duration.ofDays(LicensedAttributes.RECENTLY_EXPIRED_DAYS.intValue()));
    }

    public static Predicate<PluginLicense> isEvaluation() {
        return PluginLicense::isEvaluation;
    }

    public static Predicate<PluginLicense> isEmbeddedWithinHostLicense() {
        return PluginLicense::isEmbeddedWithinHostLicense;
    }

    public static OptionalLong daysSinceMaintenanceExpiry(PluginLicense pluginLicense) {
        Optional<ZonedDateTime> expiryDateOpt = pluginLicense.getMaintenanceExpiryZonedDate();
        if (expiryDateOpt.isPresent() && pluginLicense.isMaintenanceExpired()) {
            ZonedDateTime expiryDate = expiryDateOpt.get();
            long daysBetween = ChronoUnit.DAYS.between(expiryDate.toLocalDate(), LocalDate.now());
            return OptionalLong.of(daysBetween);
        }
        return OptionalLong.empty();
    }

    public static boolean isPluginBuyable(Option<PluginLicense> pluginLicense, boolean carebearSpecific) {
        return LicensedAttributes.isProductBuyable(LicensedAttributes.LicenseAttributes.from(pluginLicense)) && !carebearSpecific;
    }

    public static boolean isPluginTryable(Option<PluginLicense> pluginLicense, boolean carebearSpecific) {
        return LicensedAttributes.isProductTryable(LicensedAttributes.LicenseAttributes.from(pluginLicense)) && !carebearSpecific;
    }

    public static boolean isPluginRenewable(Option<PluginLicense> pluginLicense, Option<Integer> currentRoleCount) {
        return LicensedAttributes.isProductRenewable(LicensedAttributes.LicenseAttributes.from(pluginLicense), currentRoleCount);
    }

    public static boolean isPluginCrossgradeable(Option<PluginInformation> pluginInformation, HostLicenseInformation hostLicenseInformation, Option<PluginLicense> pluginLicense) {
        return LicensedAttributes.isProductCrossgradeable(pluginInformation, hostLicenseInformation, LicensedAttributes.LicenseAttributes.from(pluginLicense));
    }

    public static boolean isCrossgradableAppAndHostIsTrialDcAndAppWillFailOnFullDc(Option<PluginInformation> pluginInformation, HostLicenseInformation hostLicenseInformation, Option<PluginLicense> pluginLicense) {
        return LicensedAttributes.isProductCrossgradeable(pluginInformation, hostLicenseInformation, LicensedAttributes.LicenseAttributes.from(pluginLicense)) && hostLicenseInformation.isDataCenter() && hostLicenseInformation.isEvaluation() && pluginLicense.exists(l -> !l.isValidForDc());
    }

    public static boolean isPluginRenewableRequiringContact(Option<PluginLicense> pluginLicense, Option<Integer> currentRoleCount) {
        return LicensedAttributes.isProductRenewableRequiringContact(LicensedAttributes.LicenseAttributes.from(pluginLicense), currentRoleCount);
    }

    public static boolean isPluginUpgradable(Option<PluginLicense> pluginLicense, Option<Integer> currentRoleCount) {
        return LicensedAttributes.isProductUpgradable(LicensedAttributes.LicenseAttributes.from(pluginLicense), currentRoleCount);
    }

    public static boolean isPluginUpgradeNearlyRequired(Option<PluginLicense> pluginLicense, Option<Integer> currentRoleCount) {
        return LicensedAttributes.isProductUpgradeNearlyRequired(LicensedAttributes.LicenseAttributes.from(pluginLicense), currentRoleCount);
    }

    public static boolean isPluginUpgradeRequired(Option<PluginLicense> pluginLicense) {
        return LicensedAttributes.isProductUpgradeRequired(LicensedAttributes.LicenseAttributes.from(pluginLicense));
    }

    public static Function<PluginLicense, String> licensePluginKey() {
        return licensePluginKey;
    }

    public static Function<PluginLicense, ZonedDateTime> licenseCreationZonedDate() {
        return licenseCreationDate;
    }

    private static class IsRecentlyExpired
    implements Predicate<PluginLicense> {
        private final ZonedDateTime dateAgo;

        public IsRecentlyExpired(Duration duration) {
            this.dateAgo = ZonedDateTime.now().minus(duration);
        }

        @Override
        public boolean test(PluginLicense license) {
            return license.getExpiryZonedDate().map(d -> d.isAfter(this.dateAgo) && d.isBefore(ZonedDateTime.now())).orElse(false);
        }
    }

    private static class IsRecentlyMaintenanceExpired
    implements Predicate<PluginLicense> {
        private final ZonedDateTime dateAgo;

        public IsRecentlyMaintenanceExpired(Duration duration) {
            this.dateAgo = ZonedDateTime.now().minus(duration);
        }

        @Override
        public boolean test(PluginLicense license) {
            return license.getMaintenanceExpiryZonedDate().map(d -> d.isAfter(this.dateAgo) && d.isBefore(ZonedDateTime.now())).orElse(false);
        }
    }
}

