/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.internal;

import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.upm.license.internal.impl.DefaultLicenseDateFormatter;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;

public class ConfluenceLicenseDateFormatter
extends DefaultLicenseDateFormatter {
    private final FormatSettingsManager formatSettingsManager;
    private final UserAccessor userAccessor;

    public ConfluenceLicenseDateFormatter(FormatSettingsManager formatSettingsManager, UserAccessor userAccessor) {
        this.formatSettingsManager = Objects.requireNonNull(formatSettingsManager, "formatSettingsManager");
        this.userAccessor = Objects.requireNonNull(userAccessor, "userAccessor");
    }

    @Override
    public String formatDateTime(ZonedDateTime licenseDate) {
        return this.formatInternal(licenseDate, this.formatSettingsManager.getDateTimeFormat());
    }

    @Override
    public String formatDate(ZonedDateTime licenseDate) {
        return this.formatInternal(licenseDate, this.formatSettingsManager.getDateFormat());
    }

    @Override
    protected ZoneId getUserTimeZoneId() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        UserPreferences userPreferences = this.userAccessor.getUserPreferences(user);
        try {
            return ZoneId.of(userPreferences.getTimeZone().getWrappedTimeZone().getID());
        }
        catch (IllegalArgumentException e) {
            return ZoneId.systemDefault();
        }
    }
}

