/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.internal;

import com.atlassian.upm.api.license.entity.LicenseType;
import com.atlassian.upm.api.license.entity.SubscriptionPeriod;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.impl.DateUtil;
import com.atlassian.upm.license.internal.BaseApplicationLicense;
import com.atlassian.upm.license.internal.LicenseDateFormatter;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Optional;

public class HostApplicationLicenseAttributes
extends BaseApplicationLicense {
    public HostApplicationLicenseAttributes(Option<Integer> edition, LicenseType licenseType, boolean evaluation, boolean dataCenter, boolean autoRenewal, Option<String> sen, Optional<ZonedDateTime> lastModified, Optional<ZonedDateTime> expiryDate, Option<SubscriptionPeriod> subscriptionPeriod, boolean stack) {
        super(edition, licenseType, evaluation, dataCenter, autoRenewal, sen, lastModified, expiryDate, subscriptionPeriod, stack);
    }

    @Override
    public Option<Integer> getEdition() {
        return super.getEdition();
    }

    @Override
    public LicenseType getLicenseType() {
        return super.getLicenseType();
    }

    @Override
    public boolean isEvaluation() {
        return super.isEvaluation();
    }

    @Override
    public boolean isDataCenter() {
        return super.isDataCenter();
    }

    @Override
    public boolean isAutoRenewal() {
        return super.isAutoRenewal();
    }

    @Override
    public Option<String> getSen() {
        return super.getSen();
    }

    @Override
    public Option<SubscriptionPeriod> getSubscriptionPeriod() {
        return super.getSubscriptionPeriod();
    }

    public static Option<Date> getExpiryDate(HostApplicationLicenseAttributes attrs) {
        return DateUtil.toOption(attrs.getExpiryZonedDate().map(d -> Date.from(d.toInstant())));
    }

    public static Option<String> getExpiryDateString(HostApplicationLicenseAttributes attrs, LicenseDateFormatter dateFormatter) {
        return DateUtil.toOption(attrs.getExpiryZonedDate().map(dateFormatter::formatDate));
    }

    public static boolean isExpired(HostApplicationLicenseAttributes attrs) {
        return attrs.getExpiryZonedDate().map(d -> d.isBefore(ZonedDateTime.now())).orElse(false);
    }
}

