/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.internal.impl;

import com.atlassian.upm.license.internal.LicenseDateFormatter;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public class DefaultLicenseDateFormatter
implements LicenseDateFormatter {
    private static final String DEFAULT_DATE_TIME_FORMAT = "d MMM yyyy";
    private static final String DEFAULT_DATE_FORMAT = "d MMM yyyy";

    @Override
    public String formatDateTime(ZonedDateTime licenseDate) {
        return this.formatInternal(licenseDate, "d MMM yyyy");
    }

    @Override
    public String formatDate(ZonedDateTime licenseDate) {
        return this.formatInternal(licenseDate, "d MMM yyyy");
    }

    protected String formatInternal(ZonedDateTime licenseDate, String format) {
        Objects.requireNonNull(licenseDate, "licenseDate");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format).withZone(this.getUserTimeZoneId());
        return formatter.format(licenseDate);
    }

    protected ZoneId getUserTimeZoneId() {
        try {
            return ZoneId.of(System.getProperty("user.timezone"));
        }
        catch (IllegalArgumentException e) {
            return ZoneId.systemDefault();
        }
    }
}

