/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.internal.impl;

import com.atlassian.upm.license.internal.LicenseDateFormatter;
import com.atlassian.upm.license.internal.LicenseDatePreferenceProvider;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public class LicenseDateFormatterImpl
implements LicenseDateFormatter {
    private LicenseDatePreferenceProvider licenseDatePreferenceProvider;

    public LicenseDateFormatterImpl(LicenseDatePreferenceProvider licenseDatePreferenceProvider) {
        this.licenseDatePreferenceProvider = Objects.requireNonNull(licenseDatePreferenceProvider, "licenseDatePreferenceProvider");
    }

    @Override
    public String formatDateTime(ZonedDateTime licenseDate) {
        return this.formatInternal(licenseDate, this.licenseDatePreferenceProvider.getDateTimeFormat());
    }

    @Override
    public String formatDate(ZonedDateTime licenseDate) {
        return this.formatInternal(licenseDate, this.licenseDatePreferenceProvider.getDateFormat());
    }

    private String formatInternal(ZonedDateTime licenseDate, String format) {
        Objects.requireNonNull(licenseDate, "licenseDate");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format).withZone(this.licenseDatePreferenceProvider.getUserZoneId());
        return formatter.format(licenseDate);
    }
}

