/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.mail;

import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.mail.AbstractAtlassianMailService;
import com.atlassian.upm.mail.UpmEmail;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ConfluenceMailService
extends AbstractAtlassianMailService {
    public static final String MAIL = "mail";
    private final MultiQueueTaskManager taskManager;
    private final UserAccessor userAccessor;
    private final SettingsManager settingsManager;

    public ConfluenceMailService(MultiQueueTaskManager taskManager, UserAccessor userAccessor, SettingsManager settingsManager) {
        this.taskManager = Objects.requireNonNull(taskManager, "taskManager");
        this.userAccessor = Objects.requireNonNull(userAccessor, "userAccessor");
        this.settingsManager = Objects.requireNonNull(settingsManager, "settingsManager");
    }

    @Override
    public void sendMail(UpmEmail email) {
        this.taskManager.addTask(MAIL, (Task & Serializable)() -> this.createMailQueueItem(email).send());
    }

    @Override
    public UpmEmail.Format getUserEmailFormatPreference(UserKey userKey) {
        UserPreferences userPreferences = this.userAccessor.getUserPreferences(this.userAccessor.getExistingUserByKey(userKey));
        String mimePref = userPreferences.getString("confluence.prefs.email.mimetype").orElse(null);
        if (StringUtils.isNotBlank(mimePref) && UpmEmail.Format.TEXT.getMimeType().equals(mimePref)) {
            return UpmEmail.Format.TEXT;
        }
        return UpmEmail.Format.HTML;
    }

    @Override
    public Option<String> getInstanceName() {
        return Option.some(this.settingsManager.getGlobalSettings().getSiteTitle());
    }
}

