/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.osgi.rest.resources;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.rest.representations.UpmRepresentationFactory;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.Objects;

@AdminOnly
@Path(value="/packages")
public class PackageCollectionResource {
    private final UpmRepresentationFactory representationFactory;
    private final PermissionEnforcer permissionEnforcer;

    @Inject
    public PackageCollectionResource(UpmRepresentationFactory representationFactory, PermissionEnforcer permissionEnforcer) {
        this.representationFactory = Objects.requireNonNull(representationFactory, "representationFactory");
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer, "permissionEnforcer");
    }

    @GET
    public Response get() {
        this.permissionEnforcer.enforcePermission(Permission.GET_OSGI_STATE);
        return Response.ok(this.representationFactory.createOsgiPackageCollectionRepresentation()).type("application/vnd.atl.plugins.osgi.packages+json").build();
    }
}

