/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.osgi.rest.resources;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.osgi.Package;
import com.atlassian.upm.osgi.PackageAccessor;
import com.atlassian.upm.osgi.impl.Versions;
import com.atlassian.upm.rest.representations.UpmRepresentationFactory;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import java.util.Objects;

@AdminOnly
@Path(value="/packages/{bundleId}/{name}/{version}")
public class PackageResource {
    private final PackageAccessor packageAccessor;
    private final UpmRepresentationFactory representationFactory;
    private final PermissionEnforcer permissionEnforcer;

    @Inject
    public PackageResource(PackageAccessor packageAccessor, UpmRepresentationFactory representationFactory, PermissionEnforcer permissionEnforcer) {
        this.packageAccessor = Objects.requireNonNull(packageAccessor, "packageAccessor");
        this.representationFactory = Objects.requireNonNull(representationFactory, "representationFactory");
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer, "permissionEnforcer");
    }

    @GET
    public Response get(@PathParam(value="bundleId") long bundleId, @PathParam(value="name") String name, @PathParam(value="version") String version) {
        this.permissionEnforcer.enforcePermission(Permission.GET_OSGI_STATE);
        Package pkg = this.packageAccessor.getExportedPackage(bundleId, name, Versions.fromString(version));
        if (pkg != null) {
            return Response.ok((Object)this.representationFactory.createOsgiPackageRepresentation(pkg)).type("application/vnd.atl.plugins.osgi.package+json").build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

